<?PHP
$usermangr_secure = "-";
include_once("user_validate.php");
include_once("config.php");
//include_once("odbc-sql.php");
include_once("mssql-sql2.php");
include_once("validate.php");

global $OFFLINE;
if (strtoupper($OFFLINE) == "Y")
	header("location: offline.php");
	
$STATUSARRAY = array('0' => 'Pending', '1' => 'Backordered', '2' => 'Esc Located', '5' => 'Awaiting Shipment/Pickup', '3' => 'Shipped');

$STATUSARRAYESC = array('0' => 'Pending', '1' => 'Backordered', '5' => 'Awaiting Shipment/Pickup', '3' => 'Shipped');

$STATE_ARRAY = array(
'AL' => 'ALABAMA', 'AK' => 'ALASKA', 'AZ' => 'ARIZONA', 
'AR' => 'ARKANSAS', 'CA' => 'CALIFORNIA', 'CO' => 'COLORADO', 'CT' => 'CONNECTICUT', 
'DE' => 'DELAWARE', 'FL' => 'FLORIDA', 'GA' => 'GEORGIA', 
'GU' => 'GUAM', 'HI' => 'HAWAII', 'ID' => 'IDAHO', 'IL' => 'ILLINOIS', 'IN' => 'INDIANA', 
'IA' => 'IOWA', 'KS' => 'KANSAS', 'KY' => 'KENTUCKY', 'LA' => 'LOUISIANA', 'ME' => 'MAINE', 
'MH' => 'MARSHALL ISLANDS', 'MD' => 'MARYLAND', 'MA' => 'MASSACHUSETTS', 'MI' => 'MICHIGAN', 
'MN' => 'MINNESOTA', 'MS' => 'MISSISSIPPI', 'MO' => 'MISSOURI', 'MT' => 'MONTANA', 
'NE' => 'NEBRASKA', 'NV' => 'NEVADA', 'NH' => 'NEW HAMPSHIRE', 'NJ' => 'NEW JERSEY', 
'NM' => 'NEW MEXICO', 'NY' => 'NEW YORK', 'NC' => 'NORTH CAROLINA', 'ND' => 'NORTH DAKOTA', 
'OH' => 'OHIO', 'OK' => 'OKLAHOMA', 'OR' => 'OREGON', 'PA' => 'PENNSYLVANIA', 
'RI' => 'RHODE ISLAND', 'SC' => 'SOUTH CAROLINA', 'SD' => 'SOUTH DAKOTA', 
'TN' => 'TENNESSEE', 'TX' => 'TEXAS', 'UT' => 'UTAH', 'VT' => 'VERMONT', 
'VA' => 'VIRGINIA', 'WA' => 'WASHINGTON', 'WV' => 'WEST VIRGINIA', 'WI' => 'WISCONSIN', 'WY' => 'WYOMING'
);

$URGENT_ORDER_REASONS_ARRAY = array('00' => '(not selected)', '01' => 'Irate Customer', '02' => 'Vehicle Down',  '03' => 'Vehicle Buyback');

$YES_NO_UNKNOWN_ARRAY = array('0' => '(not selected)', '1' => 'Yes', '2' => 'No', '3' => 'Unknown');

$YES_NO_ARRAY_SAP = array('', 'Yes', 'No');

$YES_NO_ARRAY_SAP_Assoc_NoBlank = array('Y' => 'Yes', 'N' => 'No');

$SHIPMETHODS_ARRAY = array('' => '', '1' => 'PICK-UP', '2' => 'UPS Next Day', '3' => 'UPS Ground',
'4' => 'FedEx Overnight', '6' => 'FedEx 2nd Day', '7' => 'FedEx Ground', '10' => 'FedEx Priority',
'11' => 'FedEx COD', '12' => 'UPS COD', '13' => 'FedEx International', '14' => 'USPS'
);

//new order shipping array without UPS
$SHIPMETHODS_ARRAY_2 = array('' => '', '1' => 'PICK-UP',
'4' => 'FedEx Overnight', '7' => 'FedEx Ground', '10' => 'FedEx Priority',
'14' => 'USPS'
);

//order shipping array without UPS or FedEx Priority
$SHIPMETHODS_ARRAY_3 = array('' => '', '1' => 'PICK-UP',
'4' => 'FedEx Overnight', '7' => 'FedEx Ground', '14' => 'USPS'
);

//new order shipping array without UPS 12-5-2024 
$SHIPMETHODS_ARRAY_4 = array('' => '', '1' => 'PICK-UP',
'4' => 'FedEx Overnight', '7' => 'FedEx Ground', '10' => 'FedEx Priority'
);

//order shipping array without UPS or FedEx Priority 12-5-2024
$SHIPMETHODS_ARRAY_5 = array('' => '', '1' => 'PICK-UP (Included)',
'4' => 'FedEx Overnight ($15.00)', '7' => 'FedEx Ground (Included)'
);

//new order shipping array without UPS  before Bob (2-18-2022) requird removal of all but 1, 4, 7, 10, and  14
//$SHIPMETHODS_ARRAY_2 = array('' => '', '1' => 'PICK-UP',
//'4' => 'FedEx Overnight', '6' => 'FedEx 2nd Day', '7' => 'FedEx Ground', '10' => 'FedEx Priority',
//'11' => 'FedEx COD', '13' => 'FedEx International', '14' => 'USPS'
//);

//order shipping array without UPS or FedEx Priority before Bob (2-18-2022) requird removal of all but 1, 4, 7, and  14
//$SHIPMETHODS_ARRAY_3 = array('' => '', '1' => 'PICK-UP',
//'4' => 'FedEx Overnight', '6' => 'FedEx 2nd Day', '7' => 'FedEx Ground', '11' => 'FedEx COD', '13' => 'FedEx //International', '14' => 'USPS'
//);

$ODOMETER_TYPE_ARRAY = array('' => '', 'M' => 'Miles', 'K' => 'Kilometers');

$OBTAIN_VIA_ARRAY = array('' => '', 'TechII' => 'Tech II', 'Visual' => 'Visual', 'Catalog' => 'Catalog');

// Order menu
$ordermenu = "<p><strong>Order Menu</strong><br/>
<a href='orderstart.php'>Order</a><br/>
<a href='orderhome.php'>Existing Orders</a><br/>
<a href='orderstart.php'>Check Stock</a><br/>
<a href='search.php'>Search Orders</a><br/>
<a href='myinvoices.php'>Invoices</a><br/>
<a href='mycredits.php'>Credits</a><br/>
<a href='oscores.php'>Outstanding Cores</a><br/>
<a href='mymessages.php'>Messages</a><br/>
<a href='myprofile.php'>Your User Profile</a><br />";
// if the user is assigned multiple dealercodes display link to change current
if (!empty($_SESSION['mangr_multidc']))
	$ordermenu .= "<a href='curdealercode.php'>Change Dealer Code</a><br/>";
	
$ordermenu .= "<a href='logout.php'>Logout</a></p>
<p><strong>Logged in as:</strong><br/>".$_SESSION['mangr_user']."<br />
<strong>Dealer Code:&nbsp;</strong>".$_SESSION['mangr_dc']."</p>
<p><strong>Need help?</strong><br/> 
Call 1-800-886-0022<br/>
or<br/>
Email csr@techni-car.com</p>";
// ** end of order menue

for ($x = 1; $x<32; $x++)
	$DAY_ARRAY[] = "$x";

for ($x = 1; $x<13; $x++)
	$MONTH_ARRAY[] = "$x";


$year = date('Y', time());
for ($x = $year; $x>1969; $x--)
	$YEAR_ARRAY[] = "$x";

$year = date('Y', time());
for ($x = $year + 1; $x>2000; $x--)
	$MODEL_YEAR_ARRAY[] = "$x";

function addslashes_mssql($str){
	if (is_array($str)) {
		foreach($str as $id => $value) {
			$str[$id] = addslashes_mssql($value);
		}
	} else {

		$str = str_replace("'", "''", $str);
	}
	
	return $str;
}

function build_where($search) {
    foreach ($search as $column => $aval) {
        if ($aval != '') {
			$val = trim ($aval);
            switch ($column) {
				case "WebOrderNum":
					$WHERE = $WHERE." AND U_WebOrdrNbr LIKE '$val'";
				break;
				case "RONumber":
					$WHERE = $WHERE." AND U_DlrReprOrdr LIKE '%$val'";
				break;
				case "RANumber":
					$WHERE = $WHERE." AND SO_Num LIKE '$val'";
				break;
				case "vin":
					$WHERE = $WHERE." AND U_VinNbr LIKE '%$val'";
				break;
				case "CustomerName":
					$WHERE = $WHERE." AND U_CustLastName LIKE '%$val%'";
				break;
				case "PONumber":
					$WHERE = $WHERE." AND NumAtCard LIKE '%$val%'";
				break;
				case "CrNum":
					$WHERE = $WHERE." AND CR_Num LIKE '%$val%'";
				break;
				case "InvNum":
					$WHERE = $WHERE." AND Inv_Num LIKE '%$val%'";
				break;
                default:
                    $WHERE = $WHERE." AND U_WebOrdrNbr LIKE '%$val%'";
                break;
            }
        }
    }
    return $WHERE;
}

function my_array_empty($str) {
	$rtnVal = '';
    foreach ($str as $column => $val) {
        if (trim($val) != '') 
			$rtnVal = 'No';
    }
    return $rtnVal;
}
function checkboxline($ckboxname, $title, $myvalue)
{
$myline = '&nbsp;&nbsp;&nbsp;&nbsp;<input type="checkbox" name="'.$ckboxname.'" value="1"';
if ($myvalue != 0)
{
	$myline .= ' checked="checked"';
}
$myline .= '>'.$title;
return $myline;
}

function CheckForDuplicateOrder($vin, $partNum) {

	global $SQLDBName;

	$query = "EXEC tci_DupOrderCheck '".$vin."', '".$partNum."'";

		//print $query;

	if ($conn = db_open())
	{
	//print $invNum;
		$result = db_query($conn, $query);

		$rtn = db_fetch_array($result);
	//print $rtn['InvoiceNumber'];
		return($rtn['WebOrderNum']);
	}
	else
		die(sql_error());
}

function CheckForDuplicateMechOrder($rosNum, $partNum) {

	global $SQLDBName;

	$query = "EXEC tci_DupOrderCheckMech '".$rosNum."', '".$partNum."'";

		//print $query;

	if ($conn = db_open())
	{
	//print $invNum;
		$result = db_query($conn, $query);

		$rtn = db_fetch_array($result);
	//print $rtn['InvoiceNumber'];
		return($rtn['WebOrderNum']);
	}
	else
		die(sql_error());
}

function check_part_list($partnum, $partnumreq, $bo) {
	global $PQCSERVER, $PQCDBNAME, $SAPDBSERVER, $SAPDBNAME;
	global $LOCATORSVR, $LOCATORDB;
	
	$mypnr = $partnumreq;
	
	$query = "select i.itemcode as partnum, i.[ItemName], i.[U_CampElig] as campaignEligible, isnull(i.[U_ProgReq], 'No') as ProgReq, g.itmsgrpcod as prodcode, (w.onhand - w.iscommited) as available
	from [".$SAPDBSERVER."].[".$SAPDBNAME."].[dbo].oitm i (nolock) inner join [".$SAPDBSERVER."].[".$SAPDBNAME."].[dbo].oitb g (nolock) on i.ItmsGrpCod = g.ItmsGrpCod
	inner join [".$SAPDBSERVER."].[".$SAPDBNAME."].[dbo].oitw w (nolock) on i.itemcode=w.itemcode
	where i.itemcode='".$partnum."' and w.whscode='ex'";

	if ($db = db_open()) 
	{
        
		$result = db_query($db, $query);
        
		$part = db_fetch_array($result);

		if (db_num_rows($result) < '1') 
			return '##$$##';
			
		$os = array("101","102","104","107","108","109","110");
		
		if ($part['available'] <= 0 and empty($bo))
		{
			if (!in_array($part['prodcode'], $os))
				if ($part['prodcode'] != "111")
					return '##$$##';
			
			$query = "select sum(GMQty) as cnt from [".$LOCATORSVR."].[".$LOCATORDB."].dbo.inventory (nolock) where gmpartnum='". $partnum ."'";
			if ($db = db_open()) 
			{
				
				$result = db_query($db, $query);
				
				$locpart = db_fetch_array($result);
				
				if (db_num_rows($result) < '1')
					return($partnum);
				
				if ($locpart['cnt'] <= 0)
					return($partnum); 
		
			}
			else
				return($partnum);
		}
		
		if (in_array($part['prodcode'], $os))
		{
			$relocate = "location: wntychkgr.php?pn=".$partnum."&pnr=".$partnumreq."&bo=".$bo;
		}
		elseif ($part['prodcode'] == "111")
		{
			$relocate = "location: wntychkgc.php?pn=".$partnum."&pnr=".$partnumreq."&bo=".$bo;
		}
		else
		{							
			return '##$$##';
			//$_SESSION['error'] = 'Invalid Part Number.<br><p>If you have any questions, please call 1-800-886-0022 and take option 1 or email <a href="mailto:webmaster@techni-car.com">webmaster@techni-car.com</a> .';
				//$relocate = "location: error.php?msg=Invalid Part Number";
		}
		header($relocate);
    }
	
    else {
        
		die(sql_error());
		
    }
}

function get_urgent_order_reasons($SELECTED='00')
{
	$rtn = '';
	$query = "select FldValue, Descr
	from UFD1 (nolock)
	where FieldID=58
	order by FldValue";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $flds = db_fetch_all($result);
		if (!empty($flds))
		{
			foreach ($flds as $fld)
			{
				$rtn .= '<option value="'.$fld['FldValue'].'"';
				if ($SELECTED == $fld['FldValue'])
					$rtn .= ' selected';
				$rtn .= '>'.$fld['Descr'];
			}
		}
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function create_assoc_select($ASSOC_ARRAY, $SELECTED='NONE') {
	$select = '';
    foreach ($ASSOC_ARRAY as $key => $val) {
        if ($SELECTED == $key)
            $select = "$select<option value=\"$key\" selected>$val";
        else
            $select = "$select<option value=\"$key\">$val";
    }
    return $select;
}

function create_select($ARRAY, $SELECTED='NONE') {
	$select = '';
    foreach ($ARRAY as $item) {
        if ($SELECTED == $item)
            $select = "$select<option value=\"$item\" selected>$item";
        else
            $select = "$select<option value=\"$item\">$item";
    }
	return $select;
}

function get_alternats_available($pn) {
	global $SAPDBSERVER;
	global $SAPDBNAME;
	
	$query = "select a.altitem as partnum, ai.[U_FrstYr] as [fmy], ai.[U_LstYr] as [lmy], ai.ItemName, sum(w.onhand - w.iscommited) as available
	from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitm i (nolock) inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oali a (nolock) on i.itemcode=a.OrigItem 
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitw w (nolock) on a.altitem=w.itemcode
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.OITM ai (nolock) on a.AltItem=ai.ItemCode
	where i.itemcode='".$pn."' and w.whscode in ('ex','ex2') and (w.onhand - w.iscommited)>0
	group by a.altitem, ai.[U_FrstYr], ai.[U_LstYr], ai.ItemName
	order by available desc";
	//print_r($query);
	if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_all($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_other_available($pn, $dc) {
	global $SAPDBSERVER;
	global $SAPDBNAME;
	
	$query = "select a.altitem as partnum, ai.[U_FrstYr] as [fmy], ai.[U_LstYr] as [lmy], ai.ItemName, p.Price, (w.onhand - w.iscommited) as available
	from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitm i (nolock) inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oali a (nolock) on i.itemcode=a.OrigItem 
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitw w (nolock) on a.altitem=w.itemcode
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.OITM ai (nolock) on a.AltItem=ai.ItemCode
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.ITM1 p (nolock) on a.AltItem=p.ItemCode
	where i.itemcode='".$pn."' and i.QryGroup17 = 'Y'
	and w.whscode='ex' and (w.onhand - w.iscommited)>0
	and p.PriceList in (select top 1 U_ExchPL from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.crd1 where adresType='S' and U_DealerCode='".$dc."' order by linenum)
	order by available desc";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_all($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_cues_available($pn, $dc) {
	global $SAPDBSERVER;
	global $SAPDBNAME;
	
	$query = "
		select i.ItemCode as partnum, i.[U_FrstYr] as [fmy], i.[U_LstYr] as [lmy], i.ItemName, p.Price, (w.onhand - w.iscommited) as available
		from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitm i (nolock)
		inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitw w (nolock) on i.ItemCode=w.itemcode
		inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.ITM1 p (nolock) on i.ItemCode=p.ItemCode
		where i.itemcode='".$pn."' and (i.QryGroup17 = 'Y' or i.QryGroup23 = 'Y')
		and w.whscode='ex' and (w.onhand - w.iscommited)>0
		and p.PriceList in (select top 1 U_ExchPL from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.crd1 where adresType='S' and U_DealerCode='".$dc."' order by linenum)
		UNION
		select a.altitem as partnum, ai.[U_FrstYr] as [fmy], ai.[U_LstYr] as [lmy], ai.ItemName, p.Price, (w.onhand - w.iscommited) as available
		from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitm i (nolock) inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oali a (nolock) on i.itemcode=a.OrigItem 
		inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitw w (nolock) on a.altitem=w.itemcode
		inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.OITM ai (nolock) on a.AltItem=ai.ItemCode
		inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.ITM1 p (nolock) on a.AltItem=p.ItemCode
		where i.itemcode='".$pn."' and (i.QryGroup17 = 'Y' or i.QryGroup23 = 'Y')
		and w.whscode='ex' and (w.onhand - w.iscommited)>0
		and p.PriceList in (select top 1 U_ExchPL from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.crd1 where adresType='S' and U_DealerCode='".$dc."' order by linenum)";
		//print $query;
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_all($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_locator_fsos($pn){
	// "Replace by part" column in the masterfile
	$myalts = $_SESSION['LocAlts'];
	
	$query = "select [Replace by Part] as [altpn]
	from tbl_master_supplypower
	where [Part Number] = '".$pn."'";
	if ($db = db_open()) 
	{
		$result = db_query($db, $query);
		//print $query;
		// if the result contains a numeric part number, 
		// add the part number to the $alts variable and call itself again.
		// otherwise end the recursion and return the $alts variable.
		$rec = db_fetch_array($result);
		if (!empty($rec)) 
		{
			if (!empty(trim($rec['altpn'])))
			{
				if (verify_number_only($rec['altpn']))
				{
					if (!empty(trim($myalts))) 
					{
						$myalts .= ",";
					}
					$myalts .= "'".$rec['altpn']."'";
					$_SESSION['LocAlts'] = $myalts;
					get_locator_fsos($rec['altpn']);
				}
				else
				{
					return $alts;
				}					
			}
			else
			{
				return $alts;
			}	
		}
	}
	else 
	{
		die(sql_error());
	}
}
function getShipTypeFromSAP($shipType)
{
	$query = "select TrnspCode, TrnspName 
	from oshp 
	where TrnspCode not in (1,4,7)
	and TrnspCode = $shipType
	order by TrnspName";

	if ($db = db_open()) 
	{
		$result = db_query($db, $query);
		$shipRec = db_fetch_array($result);
		return($shipRec);
	}
	else 
	{
		die(sql_error());
	}
}

function get_locator_acpns($pn){
	//"replaced parts" column in the master file.
	
	$myalts = $_SESSION['LocAlts'];
	
	$query = "select [Replaces Part] as [altpn]
	from tbl_master_supplypower
	where [Part Number] = '".$pn."'";
	if ($db = db_open()) 
	{
		$result = db_query($db, $query);
		//print $query;
		// if the result contains a numeric part number, 
		// add the part number to the $alts variable and call itself again.
		// otherwise end the recursion and return the $alts variable.
		$rec = db_fetch_array($result);
		if (!empty($rec)) 
		{
			if (!empty(trim($rec['altpn'])))
			{
				if (verify_number_only($rec['altpn']))
				{
					if (!empty(trim($myalts))) 
					{
						$myalts .= ",";
					}
					$myalts .= "'".$rec['altpn']."'";
					$_SESSION['LocAlts'] = $myalts;
					get_locator_acpns($rec['altpn']);
				}
				else
				{
					return $alts;
				}					
			}
			else
			{
				return $alts;
			}	
		}
	}
	else 
	{
		die(sql_error());
	}
}
function get_cluster_pqc($qid) {
	global $PQCSERVER, $PQCDBNAME;

	$query = "SELECT TOP 10 *
	FROM [".$PQCSERVER."].[".$PQCDBNAME."].dbo.tblClusterQuestionnaire (nolock)
	WHERE guidtct = '".$qid."' 
	order by q131 desc";
	//$_SESSION['error'] = $query;
	//return "";	
	
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $Order = db_fetch_array($result);
		db_close($db);
        return($Order);
    }
    else {
        die(sql_error());
    }
}

function getcreditbody($invNum) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = "EXEC tci_GetWebCrdBody '".$invNum."'";
	
//print $invNum;
	$result = db_query($conn, $query);

	$rtn = db_fetch_array($result);
//print $rtn['InvoiceNumber'];
	return($rtn);
}
else
	die(sql_error());
}

function getcreditheader($invNum) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = "EXEC tci_GetWebCrdHdr '".$invNum."'";
	
	$result = db_query($conn, $query);

	//$num = mssql_db_num_rows($result);

	$rtn = db_fetch_array($result);

//print $rtn['InvoiceNumber'];
	return($rtn);
}
else
	die(sql_error());
}

function getcreditspage($dealercode,$orderby, $pagesize, $pagenum, $sortorder) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = "EXEC web_GetCreditsPage '".$orderby."', '".$sortorder."', '".$dealercode."', ".$pagenum.", ".$pagesize;
	
	$result = db_query($conn, $query);
	
	while ($fetch = sqlsrv_fetch_array($result))
	{
		$fetched[] = $fetch;
		}
	
		
	return($fetched);
}
else
	die(sql_error());
}

function get_eta($zip) {
	// -- 120514
	global $DBNAME;
	
	$query = "select days 
	from [".$DBNAME."].[dbo].[tblTransTime] 
	where zip = '".$zip."'";
	//echo $query;
	if ($db = db_open()) {
        
		$result = db_query($db, $query);
        
		$eta = db_fetch_array($result);

		return $eta;		
    }
	
    else {
        
		die(sql_error());
		
    }
}

function getGUID(){
    if (function_exists('com_create_guid')){
        return com_create_guid();
    } else {
        mt_srand((double)microtime()*10000);//optional for php 4.2.0 and up.
        $charid = strtoupper(md5(uniqid(rand(), true)));
        $hyphen = chr(45);// "-"
        $uuid = chr(123)// "{"
            .substr($charid, 0, 8).$hyphen
            .substr($charid, 8, 4).$hyphen
            .substr($charid,12, 4).$hyphen
            .substr($charid,16, 4).$hyphen
            .substr($charid,20,12)
            .chr(125);// "}"
        return $uuid;
    }
}

function getinvoicebody($invNum) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = "EXEC tci_GetWebInvBody '".$invNum."'";

	$result = db_query($conn, $query);

	$rtn = db_fetch_array($result);
//print $rtn['InvoiceNumber'];
	return($rtn);
}
else
	die(sql_error());
}

function getinvoiceheader($invNum) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = "EXEC tci_GetWebInvHdr '".$invNum."'";
	
	$result = db_query($conn, $query);
	//$num = mssql_db_num_rows($result);
	$rtn = db_fetch_array($result);

//print $rtn['InvoiceNumber'];
	return($rtn);
}
else
	die(sql_error());
}

function getinvoicecount($bpcode) {

	global $SAPDBSERVER;
	global $SAPDBNAME;

	$query = "select BPCode, count(*) as [cnt] FROM ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.tci_GetOOWInvoices WHERE BPCode = '".$bpcode."' GROUP BY BPCode";
	//echo $query.'<br/><br/>';
	if ($db = db_open()) {
		$result = db_query($db, $query);
		$Order = db_fetch_array($result);
		return($Order);
	}
	else
	{
		die(sql_error());			
	}
}

function getinvoicespage($dealercode,$orderby, $pagesize, $pagenum, $sortorder) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = " EXEC web_GetInvoicesPage '".$orderby."', '".$sortorder."', '".$dealercode."', ".$pagenum.", ".$pagesize;
	//echo $query;
	$result = db_query($conn, $query);

	while ($fetch = sqlsrv_fetch_array($result))
	{
		$fetched[] = $fetch;
		}
	
		
	return($fetched);
}
else
	die(sql_error());
}


function get_locator_query($query) {
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_all($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_locator_record($query) {
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_array($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_message($userName, $msgID) {
	
	global $SQLDBName;

	$fetched = "";
		
	if ($conn = db_open())
	{
		$query = " EXEC tci_GetMessage '".$userName."', '".$msgID."'";
		//print $query;
		$result = db_query($conn, $query);

		$fetched = sqlsrv_fetch_array($result);
		//while ($fetch = sqlsrv_fetch_array($result))
		//{
		//	$fetched[] = $fetch;
		//	}
		return($fetched);
	}
	else
		die(sql_error());
}

function get_messages($userName, $sortBy, $sortOrder, $unreadOnly, $pagenum, $pagesize) {
	
	global $SQLDBName;

	$fetched = "";
		
	if ($conn = db_open())
	{
		$query = " EXEC web_GetMessagesPage '".$sortBy."', '".$sortOrder."', '".$userName."', 0, ".$pagenum.", ".$pagesize.", '".$unreadOnly."'";
		
		$result = db_query($conn, $query);

		while ($fetch = sqlsrv_fetch_array($result))
		{
			$fetched[] = $fetch;
			}
		
			
		return($fetched);
	}
	else
		die(sql_error());
}


function get_new_guid($dealercode, $username) {
	$dt = date("ymdhis");
	$rtnval = "";
	$query = "INSERT INTO tblOrderGUIDS
	(username, dealerCode, orderdate)
	VALUES 
	('$username', '$dealercode', '$dt')";
	//echo $query;
	if ($db = db_open()) {
		$result = db_query($db, $query);
		if (db_changes($result) != '1') {
			$_SESSION['error'] = "There has been an error processing your request.";
			header('location: error.php');
			}
		db_close($db);

		$ID = db_insert_id();

		$query = "Select guid from tblOrderGUIDS where id=".$ID;
	    if ($db = db_open()) {
    	    $result = db_query($db, $query);
        	$rtn = db_fetch_array($result);
			$rtnval = $rtn['guid'];
		}
		db_close($db);
	}
	
	return $rtnval;
}
	
function get_order($son, $won, $dealercode) {
	global $DBNAME, $DBSERVER, $SAPDBNAME, $SAPDBSERVER;
	$weborder = "";
	$so = trim($son);
	if(!empty($won) && empty($so))
	{
		$query = "Select webordernum from [".$DBNAME."].dbo.tblorders (nolock) where webordernum=".$won;
		if ($db = db_open()) {
			$result = db_query($db, $query);
			$fetched = db_fetch_all($result);
			if(!empty($fetched))
				$weborder = $won;
		}
		else {
			die(sql_error());
		}
	}
	
	if ($weborder != "")
	{
		$query = "	SELECT CONVERT(char(20),w.CreateDate, 1) as CreateDate, CONVERT(char(20),w.UpdateDate, 1) as UpdateDate,
		w.Username, w.DealerCode, w.PartNum, w.PartNumInVehicle, w.VIN, w.Odometer,
		CONVERT(char(20),DeliveryDate, 1) as DeliveryDate,
		w.RONumber, CONVERT(char(20),w.RODate, 1) as RODate, w.DealerContactName, w.EmailAddress, w.PONumber,
		w.Complaint, w.AdditionalComments, w.CustomerName, replace(w.U_CustshipAddress, '\\r\\n', '<br/>') as Address,
		w.Warranty, w.OutOfWarranty, w.ESPWarranty, w.ESPContractNumber, w.Recheck, w.PreviousRONumber, w.GoodWill, 
		w.WarrantyClaim1878, CONVERT(char(20),w.ProductionDate, 1) as ProductionDate, w.ServiceEngineHrs, 
		w.AxleRatio, w.TireSize, w.RANumber, w.Status, w.TCIComments, w.PQCAuth, w.GWAuth, isnull(w.TacCaseNum, '') as TacCaseNum,
		isnull(o.[U_LBSICETrackOut], '') as OBTrackNum, isnull(o.[TrnspCode], w.ShipVia) as ShipVia, w.price, w.GUID, w.Campaign,
		w.ProgReq, w.KiaReplaceShroud, w.Make, w.Model, w.EngHrsReq, w.ProdType, w.PQCReq, w.OdoType, w.CUV, w.U_ObtainVia, 
		T5.[DocNum] as [InvoiceNumber], T8.[DocNum] as [CreditNumber], w.WebOrderNum, w.U_UrgOrd, w.U_UrgOrdRsn,
		case 
		when o.[TrnspCode] = 1 then 'PICK-UP'
		when o.[TrnspCode] = 2 then 'UPS Next Day'
		when o.[TrnspCode] = 3 then 'UPS Ground'
		when o.[TrnspCode] = 4 then 'FedEx Overnight'
		when o.[TrnspCode] = 5 then ''
		when o.[TrnspCode] = 6 then 'FedEx 2nd Day'
		when o.[TrnspCode] = 7 then 'FedEx Ground'
		when o.[TrnspCode] = 8 then ''
		when o.[TrnspCode] = 9 then ''
		when o.[TrnspCode] = 10 then 'FedEx Priority'
		when o.[TrnspCode] = 11 then 'FedEx COD'
		when o.[TrnspCode] = 12 then 'UPS COD'
		when o.[TrnspCode] = 13 then 'FedEx International'
		when o.[TrnspCode] = 14 then 'USPS'
		else ''
		end as [ShipViaName]
		FROM ".$DBNAME.".dbo.tblOrders w (nolock) LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.ORDR o (nolock) ON o.[U_WebOrdrNbr] = w.webordernum
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[RDR1] T1 (nolock) ON o.DocEntry = T1.DocEntry 
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[CRD1] T6 (nolock) ON T6.U_DealerCode=o.U_DealerPA
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[DLN1] T2 (nolock) ON T2.[BaseEntry]=T1.[DocEntry] 
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[ODLN] T3 (nolock)ON T2.DocEntry = T3.DocEntry 
		LEFT  JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[INV1] T4 (nolock) ON ((T4.BaseType=15 and T4.[BaseEntry]=T3.[DocEntry]) or (T4.BaseType=17 and T4.[BaseRef]=o.DocNum))
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[OINV] T5 (nolock) ON T4.DocEntry = T5.DocEntry
		LEFT JOin [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[RIN1] T7 (nolock) ON T7.DocEntry = T4.TrgetEntry
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[ORIN] T8 (nolock) on (T8.DocEntry = T7.DocEntry and T8.Cardcode=T6.Cardcode)
		WHERE w.WebOrderNum = ".$won." AND w.DealerCode = '".$dealercode."'";
		//WHERE w.WebOrderNum = ".$won;
		//print $query;
		if ($db = db_open()) {
			$result = db_query($db, $query);
			$Order = db_fetch_array($result);
			return($Order);
		}
		else {
			die(sql_error());
		}
	}
	else
	{
		$query = "SELECT CONVERT(char(20),o.CreateDate, 1) as CreateDate, CONVERT(char(20),o.UpdateDate, 1) as UpdateDate,
		'' as UserName, o.U_DealerPA as DealerCode, d.ItemCode as PartNum, isnull(d.[U_ReqItem], d.ItemCode) as PartNumInVehicle, o.U_VinNbr as VIN, o.U_Mileage as Odometer,
		CONVERT(char(20),o.U_LBSIWarrDate, 1) as DeliveryDate,
		o.U_DlrReprOrdr as RONumber, CONVERT(char(20),o.CreateDate, 1) as RODate, o.U_ContactLName as DealerContactName, '' as EmailAddress, o.NumAtCard as PONumber,
		o.U_CustDescProb as Complaint, o.Comments as AdditionalComments, isnull(w.CustomerName, o.U_CustLastName) as CustomerName, char(ascii(substring(o.[U_CustshipAddress], 2, 1))) as Address, isnull(w.City, '') as City,
		isnull(w.state, '') as State, isnull(w.zip, '') as Zip, o.U_UrgOrd, o.U_UrgOrdRsn, 
		case 
		when o.U_ExchType = 'WAR' then 1
		else 0
		end as Warranty,
		case 
		when o.U_ExchType = 'Campaign' then 1
		else 0
		end as Campaign,
		case 
		when o.U_ExchType = 'WAR' then 0
		when o.U_ExchType = 'Campaign' then 0
		else 1
		end as OutOfWarranty,
		case
		when o.U_LBSICuv = 'Yes' then 1
		else 0
		end as CUV, '' as ESPContractNumber, 
		case 
		when o.U_PrevOrdr is not null and o.U_PrevOrdr<>'' then 1
		else 1
		end as Recheck, isnull(o.U_PrevOrdr, '') as PreviousRONumber, 
		case
		when o.U_GoodWillYN = 'Yes' then 1
		when o.U_GoodWillYN = 'Y' then 1
		else 0
		end as GoodWill, '' as WarrantyClaim1878, '01/01/1980' as ProductionDate, isnull(d.U_SrvcEngHrs,0) as ServiceEngineHrs, 
		isnull(d.U_AxleRatio,'') as AxleRatio, isnull(d.U_TireSize,'') as TireSize, o.docnum as RANumber, 
		case
		when o.[U_OrdStat] >=2 AND o.[DocStatus] <>'c' then 1
		when o.U_CancelReason = '4' then 2 
		when isdate(o.U_Shipperdeldate)<> 0 then 3
		else 0
		end as Status, '' as TCIComments, d.[U_Questionnaire] as PQCAuth, isnull(o.U_GWAuth,'') as GWAuth, isnull(d.U_TACCaseNbr, '') as TacCaseNum,
		isnull(o.[U_LBSICETrackOut], 0) as OBTrackNum, o.[TrnspCode] as ShipVia, d.[Price] as price, 
		d.[U_DlrMlgSet] as ProgReq, '0' as KiaReplaceShroud, o.[U_VehMake] as Make, o.[U_VehModel] as Model, '0' as EngHrsReq, 'N' as PQCReq, 
		o.[U_MileageInd] as OdoType, o.[U_ObtainVia], T5.[DocNum] as [InvoiceNumber], T8.[DocNum] as [CreditNumber], w.WebOrderNum,
		case
		when i.itmsgrpcod = 111 then 2
		when i.itmsgrpcod = 129 then 4
		when i.itmsgrpcod in (101,102,104,107,108,109,110) then 1
		else 0
		end
		as ProdType,
		case 
		when o.[TrnspCode] = 1 then 'PICK-UP'
		when o.[TrnspCode] = 2 then 'UPS Next Day'
		when o.[TrnspCode] = 3 then 'UPS Ground'
		when o.[TrnspCode] = 4 then 'FedEx Overnight'
		when o.[TrnspCode] = 5 then ''
		when o.[TrnspCode] = 6 then 'FedEx 2nd Day'
		when o.[TrnspCode] = 7 then 'FedEx Ground'
		when o.[TrnspCode] = 8 then ''
		when o.[TrnspCode] = 9 then ''
		when o.[TrnspCode] = 10 then 'FedEx Priority'
		when o.[TrnspCode] = 11 then 'FedEx COD'
		when o.[TrnspCode] = 12 then 'UPS COD'
		when o.[TrnspCode] = 13 then 'FedEx International'
		when o.[TrnspCode] = 14 then 'USPS'
		else ''
		end as [ShipViaName]
		FROM [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.ORDR o (nolock) INNER JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.RDR1 d (nolock) ON o.DocEntry = d.DocEntry 
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.OITM i ON d.itemcode=i.itemcode
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[DLN1] T2 (nolock) ON T2.[BaseEntry]=d.[DocEntry] 
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[ODLN] T3 (nolock)ON T2.DocEntry = T3.DocEntry 
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[CRD1] T6 (nolock) ON T6.U_DealerCode=o.U_DealerPA
		LEFT  JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[INV1] T4 (nolock) ON ((T4.BaseType=15 and T4.[BaseEntry]=T3.[DocEntry]) or (T4.BaseType=17 and T4.[BaseRef]=o.DocNum))
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[OINV] T5 (nolock) ON (T4.DocEntry = T5.DocEntry and T5.cardcode=t6.cardcode)
		LEFT JOin [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[RIN1] T7 (nolock) ON T7.DocEntry = T4.TrgetEntry
		LEFT JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.[ORIN] T8 (nolock) on (T8.DocEntry = T7.DocEntry and T8.Cardcode=T6.Cardcode)
		LEFT JOIN ".$DBNAME.".dbo.tblOrders w (nolock) on o.U_WebOrdrNbr = w.WebOrderNum
		WHERE o.docnum = ".$son." AND o.U_DealerPA = '".$dealercode."'";
		//WHERE o.docnum = ".$son;
		//print $query;
		if ($db = db_open()) {
			$result = db_query($db, $query);
			$Order = db_fetch_array($result);
			return($Order);
		}
		else {
			die(sql_error());
		}
	}
}

function get_order_column_value($result, $orderby) {
		$rtnval = "";
		
		switch ($orderby)
		{
			case "col2":
				$rtnval = $result['CustomerName'];
				break;
			case "col3":
				$rtnval = $result['RANumber'];
				break;
			case "col4":
				$rtnval = $result['status'];
				break;
			case "col5":
				$rtnval = $result['CreateDate'];
				break;
			case "col6":
				$rtnval = $result['UpdateDate'];
				break;
			case "col1":
				$rtnval = $result['WebOrderNum'];
				break;
			case "default":
				$rtnval = $result['WebOrderNum'];
				break;
		}
		
		return($rtnval);
}

function getorderpage($dealercode, $status, $orderby, $pagesize, $pagenum, $sortorder) {

global $SQLDBName;
if ($conn = db_open())
{
	switch($status)
	{
		case 0:
			$query = "EXEC web_GetPendingOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;
		break;
		case 1:
			$query = "EXEC web_GetBackorderedOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;
		break;
		case 2:
			$query = "EXEC web_GetLocatedOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;
		break;
		case 3:
			$query = "EXEC web_GetShippedOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;
		break;
		case 5:
			$query = "EXEC web_GetAwaitingOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;
		break;
		default:
			$query = "EXEC web_GetPendingOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;
		break;		
	}
	
	//$query ="EXEC web_GetShippedOrdersPage '".$orderby."','".$sortorder."',".$status.",'".$dealercode."',".$pagenum.",".$pagesize;

	$result = db_query($conn,$query);
	
	while ($fetch = sqlsrv_fetch_array($result))
	{
		//print $fetch;
		$fetched[] = $fetch;
		}
	
		
	return($fetched);
}
else
	die("sql connection error");

}

function get_oscores_page($dealercode) {

global $SQLDBName;

if ($conn = db_open())
{
	$query = " EXEC web_GetOutstandingCores '".$dealercode."'";
	
	$result = db_query($conn, $query);

	while ($fetch = sqlsrv_fetch_array($result))
	{
		$fetched[] = $fetch;
		}
	
		
	return($fetched);
}
else
	die(sql_error());
}

function get_pending($dealercode, $status, $orderby) {
	$orderby = set_orderby($orderby, "");
	$query = "SELECT WebOrderNum, CustomerName, RANumber, 
	CONVERT(char(20),CreateDate, 1) as CreateDate, CONVERT(char(20),UpdateDate, 1) as UpdateDate
	FROM tblOrders (nolock)
	WHERE Status like '$status' AND DealerCode = '$dealercode'
	ORDER BY $orderby";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $Orders = db_fetch_all($result);
        return($Orders);
    }
    else {
        die(sql_error());
    }
}

function get_pending_count($dealercode, $status) {
	$query = "SELECT Count(*) as Cnt
	FROM tblOrders (nolock)
	WHERE Status like '$status' AND DealerCode = '$dealercode'";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $Orders = db_fetch_all($result);
        return($Orders);
    }
    else {
        die(sql_error());
    }
}
	
function get_pending_page($dealercode, $status, $orderby, $qty, $extWhereClause) {
	$orderby = set_orderby($orderby, "");
	$query = "SELECT top ".$qty." WebOrderNum, CustomerName, RANumber, 
	CONVERT(char(20),CreateDate, 1) as CreateDate, CONVERT(char(20),UpdateDate, 1) as UpdateDate
	FROM tblOrders (nolock)
	WHERE Status like '".$status."' AND DealerCode = '".$dealercode."'";
	if (!empty($extWhereClause))
		$query .= " AND ".$extWhereClause."";
		
	$query .= " ORDER BY $orderby";
	//print $query;
	
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $Orders = db_fetch_all($result);
        return($Orders);
    }
    else {
        die(sql_error());
    }
}

function get_pending_page_whereclause($orderby, $direction, $rowstr, $won) {
	switch ($orderby)
	{
		case "col2":
			$startrow =  "CustomerName ".$direction." '".$rowstr."' and WebOrderNum ".$direction." ".$won;
			break;
		case "col3":
			$startrow = "RANumber ".$direction." '".$rowstr."' and WebOrderNum ".$direction." ".$won;
			break;
		case "col4":			
			$startrow = "status ".$direction." ".$rowstr." and WebOrderNum ".$direction." ".$won;
		case "col5":
			$startrow = "CreateDate ".$direction." '".$rowstr."' and WebOrderNum ".$direction." ".$won;
			break;
		case "col6":
			$startrow = "UpdateDate ".$direction." '".$rowstr."' and WebOrderNum ".$direction." ".$won;
			break;
		case "col1":
			$startrow = "WebOrderNum ".$direction." ".$won;
			break;
		case "default":
			$startrow = "WebOrderNum ".$direction." ".$won;
			break;
	}

	return($startrow);
	
}

function get_query($query) {
    if ($db = db_open()) {
        $result = db_query($db, $query); 
        $rtn = db_fetch_all($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_radio_pqc($qid) {
	global $PQCSERVER, $PQCDBNAME;
	$query = "SELECT TOP 10 *
FROM [".$PQCSERVER."].[".$PQCDBNAME."].dbo.tblRadioQuestionnaire (nolock)
	WHERE guidtct = '".$qid."' order by q129 desc";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $Order = db_fetch_array($result);
		db_close($db);
        return($Order);
    }
    else {
        die(sql_error());
    }
}

function get_record($query) {
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_array($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_sap_query($query) {
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_all($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_sap_record($query) {
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_array($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
}

function get_ship_address($dealercode) {
	//**120514
	global $SAPDBNAME, $SAPDBSERVER;
	
	$query = "select d.Street, d.State, d.City, d.ZipCode, Phone = case
	when len(d.U_lbsiphone) = 10 then '('+left(d.u_lbsiphone,3)+') '+substring(d.U_lbsiphone,3,3)+'-'+right(d.U_lbsiphone,4)
	when d.U_lbsiphone is null then ''
	else d.U_lbsiphone
	end
	from [".$SAPDBSERVER."].[".$SAPDBNAME."].[dbo].[OCRD] c (nolock) inner join [".$SAPDBSERVER."].[".$SAPDBNAME."].[dbo].[crd1] d (nolock) on c.cardcode=d.cardcode 
	WHERE d.U_DealerCode = '".$dealercode."'";
	//echo $query;
	if ($db = db_open()) {
        
		$result = db_query($db, $query);
        
		$addr = db_fetch_array($result);

		return $addr;		
    }
	
    else {
        
		die(sql_error());
		
    }
}
function chk_user_email($em, $dc) {
	$Username = $_SESSION['mangr_user'];
	$query = "SELECT username
	FROM usermangr_user (nolock) 
	WHERE username = '$em' and Ref3='$dc'";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $User = db_fetch_array($result);
        return($User);
    }
    else {
        die(sql_error());
    }
}

function get_user_info() {
	global $DBNAME, $SAPDBSERVER, $SAPDBNAME;
	$Username = $_SESSION['mangr_user'];
	
	$query = "SELECT Username, d.Address as CompanyName, LastName as ContactName, r.Ref3 AS DealerCode, d.Address, d.City, d.State, d.ZipCode, 
	d.U_LBSIPhone, IsKiaDealer, IsESC, u.active, u.ID, u.CreateDate, c.shiptype, c.cardcode as SAPCardCode, r.AllowOrders, d.U_OSCemail as OSCEmail, 
	d.U_OSCemailDate as OSCEmailDate, DATEDIFF(d,isnull(d.U_OSCemailDate, '1/1/1970'),getdate()) as OSCEmailDateDiff, 
	isnull(d.U_AllowOSCemail, 'Y') as AllowOSCEmail, isnull(u.ViewedGMShipMsg,0) as ViewedGMShipMsg
	FROM [".$DBNAME."].dbo.usermangr_user u (nolock)
	INNER JOIN [".$DBNAME."].dbo.usermangr_ref r (nolock) on (u.ID = r.ID and r.Ref3 = '".$_SESSION['mangr_dc']."')
	INNER JOIN ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.OCRD c (nolock) on r.SAPCardCode collate SQL_Latin1_General_CP850_CI_AS = c.cardcode
	INNER JOIN ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.CRD1 d (nolock) on (c.cardcode=d.cardcode and r.Ref3 collate SQL_Latin1_General_CP850_CI_AS = d.U_DealerCode)
	WHERE Username = '$Username'";
	//print $query;
	if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_array($result);
        return($rtn);
    }

    else {
        die(sql_error());
    }
   
}

function get_user_info_by_email($email) {
	global $DBNAME;
	$Username = $email;
	$query = "SELECT Username, d.Address as CompanyName, LastName as ContactName, r.Ref3 AS DealerCode, d.Address, d.City, d.State, d.ZipCode, d.U_LBSIPhone, IsKiaDealer, IsESC, u.active, u.ID, u.CreateDate, c.shiptype
	FROM [".$DBNAME."].dbo.usermangr_user u (nolock)
	INNER JOIN [".$DBNAME."].dbo.usermangr_ref r (nolock) on (u.ID = r.ID and r.Ref3 = '".$_SESSION['mangr_dc']."')
	INNER JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.OCRD c (nolock) on r.SAPCardCode collate SQL_Latin1_General_CP850_CI_AS = c.cardcode
	INNER JOIN [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.CRD1 d (nolock) on (c.cardcode=d.cardcode and r.Ref3 collate SQL_Latin1_General_CP850_CI_AS = d.U_DealerCode)
	WHERE Username = '$Username'";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        $User = db_fetch_array($result);
        return($User);
    }
    else {
        die(sql_error());
    }
}

function usable_quid($guid){
	$query = "Select ID from tblOrders where guid = '".guid."'";
    if ($db = db_open()) {
        $result = db_query($db, $query);
        if (db_num_rows($result) > '0')
        	return(false);
		else
			return(true);
    }
    else {
        die(sql_error());
    }
			
}

function LoadMakes($SELECTED = '0'){
	global $PQCSERVER, $PQCDBNAME;
	$query = "SELECT ID, txtName
	FROM [".$PQCSERVER."].[".$PQCDBNAME."].dbo.tblVehicleMakes (nolock)
	ORDER BY txtName";
	//echo $query;
    if ($db = db_open()) {
       $result = db_query($db, $query);
       while( $row = db_fetch_array( $result) )
    	{
			$key = $row['ID'];
			$val = $row['txtName'];
			if ($SELECTED == $key)
				$select = "$select<option value=\"$key\" selected>$val";
			else
				$select = "$select<option value=\"$key\">$val";
		}	
       return($select);
    }
    else {
        die(sql_error());
    }
}

function LoadModels($Make = '(not selected)', $SELECTED = '0'){
	global $PQCSERVER, $PQCDBNAME;
	$query = "SELECT Model.ID, Model.txtName
	FROM [".$PQCSERVER."].[".$PQCDBNAME."].dbo.tblVehicleMakes as Make (nolock) INNER JOIN tblVehicleModels as Model (nolock) 
	ON Make.txtName=Model.txtMake
	WHERE Make.ID = '$Make' or Model.txtName = '(not selected)'
	ORDER BY Model.txtName";

	//echo $query;
    if ($db = db_open()) {
       $result = db_query($db, $query);
       while( $row = db_fetch_array( $result) )
    	{
			$key = $row['ID'];
			$val = $row['txtName'];
			if ($SELECTED == $key)
				$select = "$select<option value=\"$key\" selected>$val";
			else
				$select = "$select<option value=\"$key\">$val";
		}	
       return($select);
    }
    else {
        die(sql_error());
    }
}

function LoadDealercodes($id){
	global $DBNAME;
	global $SAPDBSERVER;
	global $SAPDBNAME;

	$SELECTED = $_SESSION['mangr_dc'];
	
	$query = "SELECT d.Address as CompanyName, r.Ref3 AS DealerCode
	FROM [".$DBNAME."].dbo.usermangr_ref r (nolock)
	INNER JOIN ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.OCRD c (nolock) on r.SAPCardCode collate SQL_Latin1_General_CP850_CI_AS = c.cardcode
	INNER JOIN ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.CRD1 d (nolock) on (c.cardcode=d.cardcode and r.Ref3 collate SQL_Latin1_General_CP850_CI_AS = d.U_DealerCode)
	WHERE r.ID = '$id'";

    if ($db = db_open()) {
       $result = db_query($db, $query);
       while( $row = db_fetch_array( $result) )
    	{
			$key = $row['DealerCode'];
			$val = $row['DealerCode'].' - '.$row['CompanyName'];
			if ($SELECTED == $key)
				$select = "$select<option value=\"$key\" selected>$val";
			else
				$select = "$select<option value=\"$key\">$val";
		}	
       return($select);
    }
    else {
        die(sql_error());
    }
}

function LoadPart($partnum, $dealercode) {
	global $SAPDBSERVER;
	global $SAPDBNAME;
	
	$query = "select i.itemcode as partnum, i.ItemName, g.itmsgrpcod as prodcode, isnull(i.U_RemanNbr,'') as remannbr, i.U_partType as wntyPartType, U_partType2 as oowPartType, t.price, i.PicturName,
	isnull(i.u_tac,0) as TacCaseNumReq, 0 as pqclevel,
	'N' as pqcrequired, (w.onhand - w.iscommited) as available,
	i.[U_CampElig] as campaignEligible, i.[U_ProgReq] as ProgReq
	from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitm i inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitb g (nolock) on i.ItmsGrpCod = g.ItmsGrpCod
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitw w (nolock) on i.itemcode=w.itemcode
	inner join ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.itm1 t (nolock) on i.itemcode=t.itemcode
	where i.itemcode='$partnum' and w.whscode='ex' 
	and t.pricelist in (select top 1 U_ExchPL from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.crd1 where adresType='S' and U_DealerCode='$dealercode' order by linenum)";
	//echo $query;
	if ($db = db_open()) {
        
		$result = db_query($db, $query);
        
		$part = db_fetch_array($result);

		return $part;		
    }
	
    else {
        
		die(sql_error());
		
    }
}
function LogCheckStock($pn, $avail, $altavail, $locavail, $initemmast) {
	$query = "Insert Into tblLogStockChecks (SAPCardCode, CheckDate, PartNumberRequested, Available, AlternatesAvailable, LocatorAvailable, visip, InItemMaster)
	VALUES
	( '".$_SESSION['mangr_cardcode']."', getdate(), '".$pn."', ".$avail.", ".$altavail.", '".$locavail."', '".$_SESSION['vip']."', ".$initemmast.")";
	//print $query;
	if ($db = db_open()) {
		$result = db_query($db, $query);
		db_close($db);
		$id = db_insert_id();
		return $id;
	}
}

function MarkGMShipMsgViewed($Username)
{
	global $DBNAME;

	$query = "UPDATE usermangr_user
	SET ViewedGMShipMsg = 1
	WHERE username = '".$Username."'";;
	if ($db = db_open()) {
		$result = db_query($db, $query);
		db_close($db);
		return true;
	}
}

function NewMsgs($UserName) {
	$query ="SELECT count(*) as cnt
	FROM tblMessages m left JOIN tblMessageRecipients t ON m.msgID=t.msgID
	LEFT JOIN usermangr_user u ON (t.msgRecipient=u.username or t.msgRecipient=u.ref3)
	LEFT JOIN tblMessagesRead r on m.msgID=r.msgID
	WHERE (u.username = '".$User['Username']."' or m.msgType='b')
	and r.msgID is null";	
}

function searchAll($search, $CardCode, $orderby, $dNull = '') {
	global $SAPDBNAME;

	if ($conn = db_open())
	{

		$query = "EXEC tci_WebSearch_4 '".$SAPDBNAME."', '".$CardCode."', '".$search['vin']."', '".$search['PONumber']."', '".$search['RONumber']."', '".$search['WebOrderNum']."', '".$search['RANumber']."', '".$search['InvNum']."', '".$search['CrNum']."', '".$search['CustomerName']."', '', '', '4'";
		//print $query;
		$result = db_query($conn,$query);
		
		while ($fetch = sqlsrv_fetch_array($result))
		{
			//print $fetch;
			$fetched[] = $fetch;
		}
		
		return($fetched);
			
	}
	else
		die(sql_error());
									
}

function search_orders($search, $dealercode, $orderby) {
	$orderby = set_orderby($orderby, "");
	$WHERE = build_where($search);
	$query = "Select isnull(SO_Num, '') as SONum, isnull(U_WebOrdrNbr, '') as WebOrderNum, U_ExchType,
	CASE WHEN Inv_Num is null THEN '' WHEN U_ExchType in ('War', 'Campaign') THEN 'NA' ELSE Cast(Inv_Num as varchar(8)) END as InvoiceNum,
	CASE WHEN CR_Num is null THEN '' WHEN CR_Num=0 THEN '' ELSE Cast(CR_Num as varchar(8)) END as CredNum,
	isnull(U_DlrReprOrdr, '') as RONum, isnull(NumAtCard, '') as PONum, convert(varchar(10), SO_Dt, 101) as OrderDate, WebOrderStatus, U_vinnbr
	from tci_GetAllOrders (nolock)";
	if (!empty($WHERE)){
			$query .= " WHERE U_DealerPA = '$dealercode' $WHERE";
	}
	else
		$query .= " WHERE U_DealerPA = '$dealercode' AND WebOrderStatus = '-1'";
					
	$query .= " ORDER BY $orderby";
	//print $query;
	if ($db = db_open()) {
        $result = db_query($db, $query);
        $Orders = db_fetch_all($result);
        return($Orders);
    }
    else {
        die(sql_error());
    }
}

function search_orders_old($search, $dealercode, $orderby) {
	$orderby = set_search_orderby($orderby, "");
	$WHERE = build_where($search);
	$query = "SELECT WebOrderNum, CustomerName, RANumber, Status,
	CONVERT(char(20),CreateDate, 1) as CreateDate, CONVERT(char(20),UpdateDate, 1) as UpdateDate
	FROM tblOrders (nolock)";
	if (!empty($WHERE)){
			$query .= " WHERE DealerCode = '$dealercode' $WHERE";
	}
	else
		$query .= " WHERE DealerCode = '$dealercode' AND status = '-1'";
					
	$query .= " ORDER BY $orderby";
	// echo $query;
	if ($db = db_open()) {
        $result = db_query($db, $query);
        $Orders = db_fetch_all($result);
        return($Orders);
    }
    else {
        die(sql_error());
    }

}

function search_pqcc($qid, $dealercode, $orderby) {
	global $PQCSERVER, $PQCDBNAME;

	$query = "SELECT q131, q62, q64, q69
	FROM [".$PQCSERVER."].[".$PQCDBNAME."].dbo.tblClusterQuestionnaire (nolock) WHERE q131 = '$qid' AND q60 = '$dealercode'
	ORDER BY $orderby";
	//echo $query;
    if ($db = db_open()) {
       $result = db_query($db, $query);
       $Orders = db_fetch_all($result);
       return($Orders);
    }
    else {
        die(sql_error());
    }
}

function search_pqcr($qid, $dealercode, $orderby) {
	global $PQCSERVER, $PQCDBNAME;

	$query = "SELECT q129, q3, q5, q10
	FROM [".$PQCSERVER."].[".$PQCDBNAME."].dbo.tblRadioQuestionnaire (nolock) WHERE q129 = '$qid' AND q1 = '$dealercode'
	ORDER BY $orderby";
	//echo $query;
    if ($db = db_open()) {
       $result = db_query($db, $query);
       $Orders = db_fetch_all($result);
       return($Orders);
    }
    else {
        die(sql_error());
    }
}

function set_orderby($orderby, $ascdesc) {
	$direction = "";
	if ($ascdesc == "DESC")
		$direction = " DESC";
		
	switch ($orderby) {
		case "col2":
			$orderby = "CustomerName".$direction.", WebOrderNum".$direction;
		break;
		case "col3":
			$orderby = "RANumber".$direction.", WebOrderNum".$direction;
		break;
		case "col4":
			$orderby = "Status".$direction.", WebOrderNum".$direction;
		break;
		case "col5":
			$orderby = "CreateDate".$direction.", WebOrderNum".$direction;
		break;
		case "col6":
			$orderby = "UpdateDate".$direction.", WebOrderNum".$direction;
		break;
		Default:
			$orderby = "WebOrderNum".$direction;
		break;
	}
	return($orderby);
}

function set_oscores_orderby($orderby) {
	switch ($orderby) {
		case "col1":
			$orderby = "T1.[DocNum]";
		break;
		case "col2":
			$orderby = "T1.[U_WebOrdrNbr]";
		break;
		case "col3":
			$orderby = "T1.[U_ShipperDelDate]";
		break;
		case "col4":
			$orderby = "T0.[U_ItemCode]";
		break;
		case "col5":
			$orderby = "T1.[U_VINNbr]";
		break;
		case "col6":
			$orderby = "T1.[U_DlrReprOrdr]";
		break;
		case "col7":
			$orderby = "DateDiff(d, T1.[U_ShipperDelDate], getdate())";
		break;
		default:
			$orderby = "T1.[U_ShipperDelDate]";
		break;
	}
	return($orderby);
}

function set_search_orderby($orderby, $ascdesc) {
	$direction = "";
	if ($ascdesc == "DESC")
		$direction = " DESC";
		
	switch ($orderby) {
		case "col2":
			$orderby = "SO_Num".$direction.", U_WebOrdrNbr".$direction;
		break;
		case "col3":
			$orderby = "Inv_Num".$direction.", U_WebOrdrNbr".$direction;
		break;
		case "col4":
			$orderby = "SO_Dt".$direction.", U_WebOrdrNbr".$direction;
		break;
		case "col5":
			$orderby = "U_DlrReprordr".$direction.", U_WebOrdrNbr".$direction;
		break;
		case "col6":
			$orderby = "NumAtCard".$direction.", U_WebOrdrNbr".$direction;
		break;
		case "col7":
			$orderby = "WebOrderStatus".$direction.", U_WebOrdrNbr".$direction;
		break;
		Default:
			$orderby = "U_WebOrdrNbr".$direction;
		break;
	}
	return($orderby);
}

function replace_ascii_control_chars($str) {
	if (is_array($str))
	{
		foreach(str as $id => $value)
		{
			$str[$id] = replace_ascii_control_chars($value);
		}
	}
	else
	{
		$str = str_replace(chr(13), "<br/>", $str);
		$str = str_replace(chr(10), "", $str);
		$str = str_replace("\r", "<br/>", $str);
		$str = str_replace("\n", "", $str);
	}
	
	return $str;
}
function strip_dashes($str) {
	$mystr = trim($str);
	$mypos = 0;
	$myout = '';
	
	while ($mypos < strlen($mystr)) {
		if (substr($mystr, $mypos, 1) != '-')
			$myout .= substr($mystr, $mypos, 1);
		$mypos++;
	}
	return $myout;
}

function stripslashes_mssql($str){
	if (is_array($str)) {
		foreach($str as $id => $value) {
			$str[$id] = stripslashes_mssql($value);
		}
	} else {
		$str = str_replace("''", "'", $str);
	}
	
	return $str;
}

function superseded_to($pn)
{
	$query = "select U_SupercedePartNbr from ".$SAPDBSERVER.".".$SAPDBNAME.".dbo.oitm where frozenfor='y' and itemcode = '".$pn."'";
	if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_array($result);
		if (!empty($rtn))
			return(superseded_to($rtn['U_SupercedePartNbr']));
		else
        	return($rtn);
    }
    else {
        die(sql_error());
    }
		
}

function tac_vin_handler($tacType, $part, $vin) {
	$tacreq = strtoupper($tacType);
	$my = '';
	
	if (!empty($vin) && strlen($vin) > 9)
	{
		if (strlen($vin) > 9)
			$my = strtoupper(substr($vin, 9, 1)); 

		$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%">TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Optional</font></td></tr></table>';
		//print $tacType.', '.$part.', '.$vin;
		switch ($tacreq){
			case "TACII":
				if ($my > 'L')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font> TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
				
			break;
			case "TCSC":
				if ($my == 'E' || $my == 'F')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td colspan="2"><font color="red">****  </font></td></tr><tr><td colspan="2" align="left"><font color="green">To obtain a case number...</font></td></tr><tr><td colspan="2" align="left"><font color="green">If this part falls under the criteria of campaign 14126 Call TCSC at 800-828-6860</font></td></tr><tr><td colspan="2" align="left"><font color="green"> otherwise call TAC at 877-446-8227</font></td></tr>
						<tr><td width="35%"><font color="red">*</font> Case Number:</td><td>&nbsp;&nbsp;<input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15"></td></tr></table>';
			break;
			case "TACIV":
				if ($my == 'J' || $my == 'H')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font>TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
			break;
			case "TACV":
				if ($my == 'G' || $my == 'H')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font>TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
			break;
			case "TAC16":
				if ($my == 'G')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font>TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
			break;
			case "TAC17":
				if ($my == 'H')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font>TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
			break;
			case "TAC18":
				if ($my == 'J')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font>TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
			break;
			case "TAC19":
				if ($my == 'K')
					$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%"><font color="red">*</font>TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Call TAC at 877-446-8227</font></td></tr></table>';
			break;
			case "TACOPT":
				$rtnval = '<table cellspacing="2" width="100%"><tr><td width="35%">TAC Case Number:</td><td><input type="text" name="order[TacCaseNum]" value="'.$part['TacCaseNum'].'" maxlength="15">				&nbsp;&nbsp;<font color="green">Optional</font></td></tr></table>';
			break;
			
			default:
				$rtnval = '<input type="hidden" name="order[TacCaseNum]" value = "">';
			break;
			
		}
			
	} 
	else
		$rtnval = '<input type="hidden" name="order[TacCaseNum]" value = "">';
		
	return($rtnval);		
	
}
function TempTACReq($pn)
	{
		global $SQLDBName;

		$query = "EXEC web_TempTACReq '".$pn."'";
			//print $query;

		if ($conn = db_open())
		{
			$result = db_query($conn, $query);

			$rtn = db_fetch_array($result);
			//print "Part Num = ".$rtn['ParnNum']."<br/>";
			return($rtn);
		}
		else
			die(sql_error());
		
	}


function upd_pwd($pwd) {
	global $DBNAME;

	$_SESSION['error']="";

	if (!empty($pwd['email'])) {
		
		$oldpassword = md5(trim($pwd['oldpwd']));
		$newpassword = md5(trim($pwd['newpwd']));
		
		$query = "update [".$DBNAME."].dbo.usermangr_user
		set password = '".$newpassword."' 
		where username = '".$pwd['email']."' and password='".$oldpassword."'";
			
		if ($db = db_open()) {
			$result = db_query($db, $query);
			if (db_changes($result) != '1') {
				$_SESSION['error'] = "There has been an error processing your request. ".sql_error;
			}
			db_close($db);
			if (empty($_SESSION['error'])) {
				$_SESSION['needspw'] = "";
				header('location: confirm_pwd.php');
			}
		}
		else
			$_SESSION['error'] = "SQL error opening database.";	
	}
	else
		$_SESSION['error'] = "A valid email address is required.";
}

function upd_user($user) {
	global $DBNAME;

	$_SESSION['error']="";

	$query = "update [".$DBNAME."].dbo.usermangr_user
	set username = '".$user['email']."', LastName='".$user['name']."'
	where ID = '".$user['ID']."'";
	//print $query;
	if ($db = db_open()) {
		$result = db_query($db, $query);
		if (db_changes($result) != '1') {
			$_SESSION['error'] = "There has been an error processing your request.";
			}
		db_close($db);
	}
	else
		$_SESSION['error'] = "SQL error opening database.";
}

function upd_ocs_email($user) {
	global $SAPDBNAME;
	global $SAPDBSERVER;
	
	$rtnVal = "";
	
	$query = "update [".$SAPDBSERVER."].[".$SAPDBNAME."].dbo.crd1
	set U_AllowOSCemail = '".$user['AllowOSCEmail']."', U_OSCemail='".$user['OSCEmail']."', U_OSCemailDate = getdate()
	where cardcode = '".$user['SAPCardCode']."' and U_DealerCode = '".$user['dealercode']."'";
	
	if ($db = db_open()) {
		$result = db_query($db, $query);
		if (db_changes($result) != '1') {
			$rtnVal = "There has been an error processing your request.";
		}
		db_close($db);
	}
	else
		$rtnVal = "SQL error opening database.";
	
	return $rtnVal;
}


function unread_messages($username) {
	
	$query = "SELECT m.msgID
	FROM tblMessages m left JOIN tblMessageRecipients t ON m.msgID=t.msgID
	LEFT JOIN usermangr_user u ON (t.msgRecipient=u.username or t.msgRecipient=u.ref3)
	WHERE (u.username = '".$username."' or m.msgType='b')
	and m.msgID not in (SELECT msgID from tblMessagesRead WHERE msgID=m.msgID and username='".$username."')";
    //print $query;
	if ($db = db_open()) {
        $result = db_query($db, $query);
        $rtn = db_fetch_array($result);
        return($rtn);
    }
    else {
        die(sql_error());
    }
		
}

function valid_email_address($emailaddr) {
	
	if (filter_var($emailaddr, FILTER_VALIDATE_EMAIL)) 
	{
		return 'Y';
	} 
	else 
	{
		return 'N';
	}
}

?>
