<?PHP
// 7/4/11
function verify_alphanumeric($data) {
	if(!preg_match("/[^A-Za-z0-9]/", $data))
		return true;
	else 
		return false;
}

function verify_length($data, $low, $high) {
	if ((strlen($data) >= $low) && (strlen($data) <= $high))
		return true;
	else
		return false;
}

function verify_date($data)
{
	//return true;
	$curdate= strtotime(date("m/d/y"));
	
	$mydate = strtotime( $data );
	if (is_numeric($mydate))
	{
		$Month = date( 'm', $mydate );
		$Day   = date( 'd', $mydate );
		$Year  = date( 'Y', $mydate );
	}
	else
		return false;
	
	
	if (checkdate( $Month, $Day, $Year ))
	{
		if ($mydate <= $curdate)
			return true;
		else
			return false;
	}
	else 
		return false;
}

function verify_number_only($data){
	if(is_numeric($data))
	{
		if(preg_match("/[^0-9]/", $data))
			return false;
		else
			return true;
	}
	else
		return false;
}

function get_dealer_users($dc, $SELECTED) {
	// -- 7/24/2012
	global $DBSERVER, $DBNAME;
	
	$query = "select username as email 
	from [".$DBSERVER."].[".$DBNAME."].[dbo].[usermangr_user] 
	where Ref3 = '".$dc."'";
    if ($db = db_open()) {
       $result = db_query($db, $query);
       while( $row = db_fetch_array( $result) )
    	{
			$key = $row['email'];
			$val = $key;
			if ($SELECTED == $key)
				$select = "$select<option value=\"$key\" selected>$val";
			else
				$select = "$select<option value=\"$key\">$val";
		}	
       return($select);
    }
    else {
        die(sql_error());
    }
}

function validategrc($order, $tidi_fields, $tidierr, $tidi_date_fields) {
	global $SAPDBNAME;
	$err_list = "";
	$strVar = "";
	$wnty = "";
	$vin = $order['VIN'];
	$wntystatus = $order['RepairStatus'];
	
	try
	{
		if (empty($order['DealerCode']) || empty($order['Username']) || empty($order['PartNum']))
		{
			$err_list .= 'An error has occurred saving your order. <br />
			Please reenter your order by clicking <a href="orderstart.php">here</a>. <br />
			If this problem persists, please call 800-866-0022 to place your order, then ask for web site support.<br />
			We apologize for this inconvinience.';
		}
		else
		{	
			//	verify vin
			if (empty($order['VIN']))
				$err_list .= "VIN Missing.<br/>";
			else if (strlen($order['VIN']) != 17)
				$err_list .= "VIN Must Be 17 Digits.<br/>";
			
			// verify mileage
			if (empty($order['Odometer']))
				$err_list .= "Odometer Reading Missing.<br/>";
			else if (!verify_number_only($order['Odometer']))
				$err_list .= "Odometer Reading Must Be Numeric with no decimal point.<br/>";
			
			if (empty($order['U_MileageInd']))
				$err_list .= "Invalid Odometer Type. <br/>";
			
			if (!verify_date($order['RODate']))
				$err_list .= "Invalid RO Date. <br/>";
			
			if (empty($order['DealerContactName']))
				$err_list .= "Dealer Contact Name Missing. <br/>";
			if (empty($order['CustomerName']))
				$err_list .= "Customer Name Missing. <br/>";
	
			$str = trim($order['Complaint']);
			if (empty($str))
				$err_list .= "Product Failure Symptom Missing. <br/>";

			if (empty($order['PONumber']))
				$err_list .= "PO Number Missing. <br/>";
			
			// for warranty status
			switch ($wntystatus) {
				case "Warranty":
					$wnty = "y";
					// check delivery date
					//if (!verify_date($order['DeliveryDate']))
					//	$err_list .= "Invalid Delivery Date. <br/>";
					// check method used to obtain part number
					if (empty($order['U_ObtainVia']))
						$err_list .= "Part Number Obtained From Required.<br/>";
					// check ro #
					if (empty($order['RONumber']))
						$err_list .= "RO # Missing.<br/>";
					else if (! verify_length($order['RONumber'], "6", "8"))
						$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
					else if (! verify_alphanumeric($order['RONumber']))
						$err_list .= "RO # must be Alpha-mumeric.<br/>";
						
				break;
				case "Campaign":
					$wnty = "y";
					//if (!verify_date($order['DeliveryDate']))
					//	$err_list .= "Invalid Delivery Date. <br/>";
					if (empty($order['U_ObtainVia']))
						$err_list .= "Part Number Obtained From Required.<br/>";
					// check ro #
					if (empty($order['RONumber']))
						$err_list .= "RO # Missing.<br/>";
					else if (! verify_length($order['RONumber'], "6", "8"))
						$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
					else if (! verify_alphanumeric($order['RONumber']))
						$err_list .= "RO # must be Alpha-mumeric.<br/>";
				break;
				case "CUV":
					$wnty = "y";
					//if (!verify_date($order['DeliveryDate']))
					//	$err_list .= "Invalid Delivery Date. <br/>";
					if (empty($order['U_ObtainVia']))
						$err_list .= "Part Number Obtained From Required.<br/>";
					// check ro #
					if (empty($order['RONumber']))
						$err_list .= "RO # Missing.<br/>";
					else if (! verify_length($order['RONumber'], "6", "8"))
						$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
					else if (! verify_alphanumeric($order['RONumber']))
						$err_list .= "RO # must be Alpha-mumeric.<br/>";
				break;
			}
	
			if ($order['Goodwill'] == '1')
				if (empty($order['GWAuth']))
						$err_list .= "Goodwill Authorization Missing. <br/>";
			
			if ($order['recheckYN'] == "Yes")
					if (empty($order['PreviousRONumber']))
						$err_list .= "Previous RO # Missing. <br/>";
					
			if (!empty($order['PreviousRONumber']))
			{
				if (!verify_length($order['PreviousRONumber'], "6", "8"))
					$err_list .= "Previous RO # must be at least 6 and no more than 8 digits long.<br/>";
				else if (! verify_alphanumeric($order['PreviousRONumber']))
					$err_list .= "Previous RO # must be Alpha-mumeric.<br/>";
			}
	
			if ($order['EngHrsReq'] == 0)
				$err_list .= "Does vehicle required Service Engine Hours to be programmed? Requires an answer.<br />";
			else
			{
				$strVar = $order['EngHrsReq'];
				if ($strVar == "1")
				{
					if (empty($order['ServiceEngineHrs']))
						$err_list .= "Service Engine Hours Missing. <br />";
					else if (!is_numeric($order['ServiceEngineHrs']))
						$err_list .= "Service Engine Hours Must Be Numeric.<br/>";
				}		
			}
			
			if ($order['U_UrgOrd'] == 'Y')
			{
				if (!empty($order['U_UrgOrdRsn']))
				{
					if ($order['U_UrgOrdRsn'] == '00')
						$err_list .= "Urgent Order Reason Required. <br />";
				}
				else
					$err_list .= "Urgent Order Reason Required. <br />";
			}
					
			$tacFieldExists = "";
			// check for PQC, if so check for authorization.
			if ($order['pqclevel'] == 1)
				if  (empty($order['PQCAuth']))
					$err_list .= "PQC Authorization Required!<br/>";
			
			if (!empty($tidi_fields))
			{
				foreach($tidi_fields as $tidi_field)
				{
					if ($tidi_field == 'TacCaseNum')
					{
						$tacFieldExists = 'yes';
						$trimtac = trim($order[$tidi_field]);
						if (empty($trimtac))
						{
							$my = '';
							if (strlen($vin) > 9)
								$my = strtoupper(substr($vin, 9, 1)); 
								
							switch($tidierr[$tidi_field])
							{
								case "TACII":
								{
									if (!empty($vin) && ($my > 'E'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TACIV":
								{
									if (!empty($vin) && ($my == 'J' || $my == 'H'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TAC16":
								{
									if (!empty($vin) && ($my == 'G'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TAC17":
								{
									if (!empty($vin) && ($my == 'H'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TAC18":
								{
									if (!empty($vin) && ($my == 'J'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TAC19":
								{
									if (!empty($vin) && ($my == 'K'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TCSC":
								{
									if (!empty($vin) && ($my == 'E' || $my == 'F'))
										$err_list .= "A Case Number is required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TACV":
								{
									if (!empty($vin) && ($my == 'G' || $my == 'H'))
										$err_list .= "TAC Number required for this MY vehicle. <br />";
									else
										$tacFieldExists = '';									
								}
								break;
								case "TACATS":
									$err_list .= "TAC Number required. <br />";
								break;
								case "required":
									$err_list .= "TAC Number required. <br />";
								break;
							}
						}
					}
					else
					{
						if (empty($order[$tidi_field]))
							if ($tidi_field != 'ServiceEngineHrs')
								$err_list .= $tidierr[$tidi_field]." <br />";
					}
				}
								
				if (empty($err_list))
				{
					if (!empty($tidi_date_fields))
					{
						foreach($tidi_date_fields as $tidi_field)
						{
							if (!verify_date($order[$tidi_field]))
								$err_list .= $tidierr[$tidi_field]." <br />";
						}
					}
				}
			}
			// check to see if the tac number tidi already exists 
			if (empty($tacFieldExists))
			{
				if (!empty($wnty))
				{
					if (!empty($order['RadioTACTidi']))
					{
						//check to see if radio has been here within the last six months
						$query = "select o.docnum
						from [SAPSQL].".$SAPDBNAME.".[dbo].ordr o inner join [SAPSQL].[".$SAPDBNAME."].[dbo].rdr1 d (nolock) on o.DocEntry = d.DocEntry
						inner join [SAPSQL].".$SAPDBNAME.".[dbo].[@LBSICEMSTR] c (nolock) on o.DocNum=c.[U_SO_DocNum]
						where o.[U_VinNbr]='".$order['VIN']."' and (d.ItemCode='".$order['PartNumInVeh']."' or d.[U_ReqItem]='".$order['PartNumInVeh']."' 
						or o.[U_DealerAlt]='".$order['PartNumInVeh']."') and o.U_Shipperdeldate >= dateadd(d, -180, getdate())
						and c.[U_ReturnUnused] <> 'y'";
	
						$result = get_sap_record($query);
	
						if (!empty($result))
						{
							if (empty($order['TacCaseNum']))
							{
								$_SESSION['tacreq'] = 'yes';
								$err_list .= "Recheck within 6 months of previous repair or exchange. TAC Case Number Required. <br />";
							}
						}
					}
				}
			}
			
			//  check to see if shipping method has been selected.
			if (empty($order['ShipVia']))
			{
				$err_list .= "Ship Via must be selected. <br />";
			}
		}
	}
	catch(Exception $err)
	{
		$err_list .= "Captured Error : ".$err->getMessage() + " <br/>";
	}

	if (!empty($err_list))
		$rtnVal = "<p><font color=red>".$err_list."</font></p>";
	else
		$rtnVal = "";
		
	return $rtnVal;
}

function validateg($order) {
	global $SAPDBNAME;
	$err_list = "";
	$strVar = "";
	$wnty = "";
	$vin = $order['VIN'];
	$wntystatus = $order['RepairStatus'];
	
	try
	{
		if (empty($order['DealerCode']) || empty($order['Username']) || empty($order['PartNum']))
		{
			$err_list .= 'An error has occurred saving your order. <br />
			Please reenter your order by clicking <a href="orderstart.php">here</a>. <br />
			If this problem persists, please call 800-866-0022 to place your order, then ask for web site support.<br />
			We apologize for this inconvinience.';
		}
		else
		{	
			//	verify vin
			if (empty($order['VIN']))
				$err_list .= "VIN Missing.<br/>";
			else if (strlen($order['VIN']) != 17)
				$err_list .= "VIN Must Be 17 Digits.<br/>";
			
			// verify mileage
			if (empty($order['Odometer']))
				$err_list .= "Odometer Reading Missing.<br/>";
			else if (!verify_number_only($order['Odometer']))
				$err_list .= "Odometer Reading Must Be Numeric with no decimal point.<br/>";
			
			if (empty($order['U_MileageInd']))
				$err_list .= "Invalid Odometer Type. <br/>";
			
			if (!verify_date($order['RODate']))
				$err_list .= "Invalid RO Date. <br/>";
			
			if (empty($order['DealerContactName']))
				$err_list .= "Dealer Contact Name Missing. <br/>";
			if (empty($order['CustomerName']))
				$err_list .= "Customer Name Missing. <br/>";
	
			$str = trim($order['Complaint']);
			if (empty($str))
				$err_list .= "Product Failure Symptom Missing. <br/>";
			
			// for warranty status
			switch ($wntystatus) {
				case "OutOfWarranty":
					if (empty($order['PONumber']))
						$err_list .= "PO Number Missing. <br/>";
				break;
				case "Warranty":
					$wnty = "y";
					// check delivery date
					//if (!verify_date($order['DeliveryDate']))
					//	$err_list .= "Invalid Delivery Date. <br/>";
					// check method used to obtain part number
					if (empty($order['U_ObtainVia']))
						$err_list .= "Part Number Obtained From Required.<br/>";
					// check ro #
					if (empty($order['RONumber']))
						$err_list .= "RO # Missing.<br/>";
					else if (! verify_length($order['RONumber'], "6", "8"))
						$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
					else if (! verify_alphanumeric($order['RONumber']))
						$err_list .= "RO # must be Alpha-mumeric.<br/>";
						
				break;
				case "Campaign":
					$wnty = "y";
					//if (!verify_date($order['DeliveryDate']))
					//	$err_list .= "Invalid Delivery Date. <br/>";
					if (empty($order['U_ObtainVia']))
						$err_list .= "Part Number Obtained From Required.<br/>";
					// check ro #
					if (empty($order['RONumber']))
						$err_list .= "RO # Missing.<br/>";
					else if (! verify_length($order['RONumber'], "6", "8"))
						$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
					else if (! verify_alphanumeric($order['RONumber']))
						$err_list .= "RO # must be Alpha-mumeric.<br/>";
				break;
				case "CUV":
					$wnty = "y";
					//if (!verify_date($order['DeliveryDate']))
					//	$err_list .= "Invalid Delivery Date. <br/>";
					if (empty($order['U_ObtainVia']))
						$err_list .= "Part Number Obtained From Required.<br/>";
					// check ro #
					if (empty($order['RONumber']))
						$err_list .= "RO # Missing.<br/>";
					else if (! verify_length($order['RONumber'], "6", "8"))
						$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
					else if (! verify_alphanumeric($order['RONumber']))
						$err_list .= "RO # must be Alpha-mumeric.<br/>";
				break;
			}
	
			if ($order['Goodwill'] == '1')
				if (empty($order['GWAuth']))
						$err_list .= "Goodwill Authorization Missing. <br/>";
			
			if ($order['recheckYN'] == "Yes")
					if (empty($order['PreviousRONumber']))
						$err_list .= "Previous RO # Missing. <br/>";
					
			if (!empty($order['PreviousRONumber']))
			{
				if (!verify_length($order['PreviousRONumber'], "6", "8"))
					$err_list .= "Previous RO # must be at least 6 and no more than 8 digits long.<br/>";
				else if (! verify_alphanumeric($order['PreviousRONumber']))
					$err_list .= "Previous RO # must be Alpha-mumeric.<br/>";
			}
		
			//  check to see if shipping method has been selected.
			if (empty($order['ShipVia']))
			{
				$err_list .= "Ship Via must be selected. <br />";
			}
		}
	}
	catch(Exception $err)
	{
		$err_list .= "Captured Error : ".$err->getMessage() + " <br/>";
	}

	if (!empty($err_list))
		$rtnVal = "<p><font color=red>".$err_list."</font></p>";
	else
		$rtnVal = "";
		
	return $rtnVal;
}

function validatepqcc($pqc)
{
	$err_list = "";
	$rtnVal = "";
	
	// verify make
	//if (empty($pqc['q136']))
	//	$err_list .= "Vehicle Make Required.<br/>";
			
	// verify make
	//if (empty($pqc['q137']))
	//err_list .= "Vehicle Model required.<br/>";
	
	// verify make
	//if (empty($pqc['q138']))
	//	$err_list .= "Veicle Model Year required.<br/>";
	
	// verify Service Tech Name
	if (empty($pqc['q70']))
		$err_list .= "Service Tech Name required. <br/>";
	
	// verity Service Tech Phone Number
	//if (empty($pqc['q71']))
	//$err_list .= "Service Tech Phone Number required. <br/>";
	
	// Check for problem type
	$problemtype = 0;
	if ($pqc['s27'] == 1) 
		$problemtype = 1;
		
	if ($pqc['s28'] == 1)
		$problemtype = 1;
		
	if ($pqc['s29'] == 1)
		$problemtype = 1;
		
	if ($pqc['s30'] == 1)
		$problemtype = 1;
		
	if ($pqc['s31'] == 1)
		$problemtype = 1;
		
	if ($problemtype == 0)		
		$err_list .= "At least one Problem Type must be selected. <br/>";

	// verify Customer Complaint
	//if (empty($pqc['q74']))
	//	$err_list .= "Questionnaire Section B Customer Complaint required. <br/>";

	// see if "Was problem duplicated and/or verified?" was answered 
	if ($pqc['q225yes'] != 1 && $pqc['q225no'] != 1)
		$err_list .= "Questionnaire Section B Question 2 requires a response. <br/>";


	if (!empty($err_list))
		$rtnVal = "<p><font color=red>".$err_list."</font></p>";
	else
		$rtnVal = "";
		
	return $rtnVal;
	
		
}


?>