<!--

function Left(str, n){
	if (n <= 0)
	    return "";
	else if (n > String(str).length)
	    return str;
	else
	    return String(str).substring(0,n);
}
function Right(str, n){
    if (n <= 0)
       return "";
    else if (n > String(str).length)
       return str;
    else {
       var iLen = String(str).length;
       return String(str).substring(iLen, iLen - n);
    }
}

function validate_vin(strVIN) {
	var strVIN = strVIN.toUpperCase();
	var lngSubTotal = 0;
	for (Idx=0; Idx<17; Idx++) {
		if (Idx != 8) {
			switch(Idx+1) {
				case 1: 
				case 11:
					var intWF = 8;
					break;
				case 2:
				case 12:
					var intWF = 7;
					break;
				case 3:
				case 13:
					var intWF = 6;
					break;
				case 4:
				case 14:
					var intWF = 5;
					break;
				case 5:
				case 15:
					var intWF = 4;
					break;
				case 6:
				case 16:
					var intWF = 3;
					break;
				case 7:
				case 17:
					var intWF = 2;
					break;
				case 8:
					var intWF = 10;
					break;
				case 10:
					var intWF = 9;
			}
			switch(strVIN.charAt(Idx)) {
				case "1":
				case "A":
				case "a":
				case "J":
				case "j":
					var intNV = 1;
					break;
				case "2":
				case "B":
				case "b":
				case "K":
				case "k":
				case "S":
				case "s":
					var intNV = 2;
					break;
				case "3":
				case "C":
				case "L":
				case "T":
					var intNV = 3;
					break;
				case "4":
				case "D":
				case "M":
				case "U":
					var intNV = 4;
					break;
				case "5":
				case "E":
				case "N":
				case "V":
					var intNV = 5;
					break;
				case "6":
				case "F":
				case "W":
					var intNV = 6;
					break;
				case "7":
				case "G":
				case "P":
				case "X":
					var intNV = 7;
					break;
				case "8":
				case "H":
				case "Y":
					var intNV = 8;
					break;
				case "9":
				case "R":
				case "Z":
					var intNV = 9;
					break;
				default:
					var intNV = 0;
			}
			lngSubTotal = lngSubTotal+(intNV*intWF);
		}
	}
	intCalcCD = lngSubTotal % 11;
	if (intCalcCD == 10)
		strCalcCD = "X";
	else
		strCalcCD = intCalcCD.toString();
	strVINCD = strVIN.charAt(8);
	if (strCalcCD == strVINCD)
		return true;
	else
		return false;
}

function verify_alphanumeric(data, length) {
	regex = /(^[0-9a-zA-Z]+$)/.test(data);
	if (regex) {
		if (length=="any")
			return true;
		else if (data.length == length)
			return true;
	}
	return false;
}

function verify_numeric(data, length) {
	regex = /(^\d+$)/.test(data);
	if (regex) {
		if (length=="any")
			return true;
		else if (data.length == length)
			return true;
	}
	return false;
}

function verify_length(data, low, high) {
	if ((data.length >= low) && (data.length <= high))
		return true;
	else
		return false;
}

function verify_date(data) {
	regex = /^(\d{1,2})\/(\d{1,2})\/(\d{2,4})$/.test(data);
	if (regex){
		var myDateParts = data.split("/");
		var myYear = myDateParts[2];
		if (myYear < 1000) {
			if (myYear < 50)
				myYear = '20' + myYear;
			else
				myYear = '19' + myYear;
		}
		var d = new Date(myYear, myDateParts[0]-1, myDateParts[1]);
		var now = new Date();
		if ((d.getFullYear() == myYear) && (d.getMonth() + 1 == myDateParts[0]) && (d.getDate() == myDateParts[1])) {
			if (d <= now)
				return true;
		}
	}
	return false;
}

function validategrc() {
	var empty_list = "";
	var strVar = "";
	var checkTIDIs = "";
	var myform = document.neworder;
	var wntystatus = myform.elements["order[RepairStatus]"].value;

	try
	{

		//	verify vin
		if (! myform.elements["order[VIN]"].value)
			empty_list = empty_list + "VIN Missing.\n";
		else if (! verify_length(myform.elements["order[VIN]"].value, "17", "17"))
			empty_list = empty_list + "VIN Must Be 17 Digits.\n";
	//	else if (! myform.elements["override"].checked ) {
	//		if (! validate_vin(myform.elements["order[VIN]"].value)) {
	//			empty_list = empty_list + "VIN Is Invalid.\n";
	//			document.getElementById('vin_override').innerHTML = '<i>Override Validation</i> <input type="checkbox" name="override" >';
	// 		}
		// }
		
		// verify mileage
		if (! myform.elements["order[Odometer]"].value)
			empty_list = empty_list + "Odometer Reading Missing.\n";
		else if (! verify_numeric(myform.elements["order[Odometer]"].value, "any"))
			empty_list = empty_list + "Odometer Reading Must Be Numeric.\n";
		
		if (! myform.elements["order[U_MileageInd]"].value)
			empty_list = empty_list + "Invalid Odometer Type. \n";
			
		// check for PQC, if so check for authorization.
		if (myform.elements["order[pqclevel]"].value == 1)
			if  (!myform.elements["order[PQCAuth]"].value)
				empty_list = empty_list + "PQC Authorization Required!\n";
				
		// check ro #
		if (! myform.elements["order[RONumber]"].value)
			empty_list = empty_list + "RO # Missing.\n";
		else if (! verify_length(myform.elements["order[RONumber]"].value, "6", "8"))
			empty_list = empty_list + "RO # must be at least 6 and no more than 8 digits long.\n";
		else if (! verify_alphanumeric(myform.elements["order[RONumber]"].value, "any"))
			empty_list = empty_list + "RO # must be Alpha-mumeric.\n";
		
		if (!verify_date(myform.elements["order[RODate]"].value))
			empty_list = empty_list + "Invalid RO Date. \n";
		
		if (! myform.elements["order[DealerContactName]"].value)
			empty_list = empty_list + "Dealer Contact Name Missing. \n";
		if (! myform.elements["order[CustomerName]"].value)
			empty_list = empty_list + "Customer Name Missing. \n";
		if (! myform.elements["order[Complaint]"].value)
			empty_list = empty_list + "Product Failure Symptom Missing. \n";
	
		// for warranty status
		//if (myform.elements["order[RepairStatus]"])
		//{
			//empty_list = empty_list + "Got here! " + myform.elements["order[RepairStatus]"].value + " \n";
			switch (wntystatus) {
				case "OutOfWarranty":
					if (! myform.elements["order[PONumber]"].value)
						empty_list = empty_list + "PO Number Missing. \n";
				break;
				case "Warranty":
					checkTIDIs = "y";
					if (!verify_date(myform.elements["order[DeliveryDate]"].value))
						empty_list = empty_list + "Invalid Delivery Date. \n";
				break;
				case "Campaign":
					checkTIDIs = "y";
					if (!verify_date(myform.elements["order[DeliveryDate]"].value))
						empty_list = empty_list + "Invalid Delivery Date. \n";
				break;
				case "CUV":
					checkTIDIs = "y";
					if (!verify_date(myform.elements["order[DeliveryDate]"].value))
						empty_list = empty_list + "Invalid Delivery Date. \n";
				break;
			}
		//}
		//else
		//	empty_list = empty_list + "Invalid Repair Status. \n";		

		if (myform.elements["order[Goodwill]"].type == "checkbox")
		{
			if (myform.elements["order[Goodwill]"].checked)
			{
				if (! myform.elements["order[GWAuth]"].value)
						empty_list = empty_list + "GM Authorization Missing. \n";
			}
		}
		
		if (myform.elements["order[recheckYN]"] == "Yes")
				if (! myform.elements["order[PreviousRONumber]"].value)
					empty_list = empty_list + "Previous RO # Missing. \n";
		
		
		if (myform.elements["order[sapProgReq]"].value == "Inquire")
		{
			if (! myform.elements["order[ProgReq]"].value)
				empty_list = empty_list + "Do you want Techni-Car to program this part for you? \n";
			else
				strVar = myform.elements["order[ProgReq]"].value;
				
		}

		if (strVar == "1" || myform.elements["order[sapProgReq]"].value == "Yes")
		{
			if (myform.elements["order[EngHrsReg"])
			{
				if (! myform.elements["order[EngHrsReq]"].value)
					empty_list = empty_list + "Does vehicle required Service Engine Hours to be programmed? \n";
				else
				{
					strVar = myform.elements["order[EngHrsReq]"].value;
					if (strVar == "1")
						if (! myform.elements["order[ServiceEngineHrs]"].value)
							empty_list = empty_list + "Service Engine Hours Missing. \n";
				}
			}
		}
		
		if (checkTIDIs == "y")
		{
			if (myform.tidis)
			{
				if (myform.tidis.length)
				{
					for (x = 0; x<myform.tidis.length; x++) {
						nm = "order[" + myform.tidis[x].value + "]";
						if (! myform.elements[nm].value)
						{
							nme = "tidierr[" + myform.tidis[x].value + "]";
							empty_list = empty_list + myform.elements[nme].value + " \n";
						}
					}
				}
				else
				{
					nm = "order[" + myform.elements["tidis"].value +"]";
					if (! myform.elements[nm].value)
					{
						nme = "tidierr[" + myform.elements["tidis"].value + "]";
						empty_list = empty_list + myform.elements[nme].value + " \n";
					}
				}
			}
		}

		if (myform.tidi_dates)
		{
			if (myform.tidi_dates.length)
			{
				for (x = 0; x<myform.tidi_dates.length; x++) {
					nm = "order[" + myform.tidi_dates[x].value + "]";
					if (!verify_date(myform.elements[nm].value))
					{
						nme = "tidierr[" + myform.tidi_dates[x].value + "]";
						empty_list = empty_list + myform.elements[nme].value + " \n";
					}
				}
			}
			else
			{
				nm = "order[" + myform.elements["tidis_dates"].value +"]";
				if (!verify_date(myform.elements[nm].value))
				{
					nme = "tidierr[" + myform.elements["tidis_dates"].value + "]";
					empty_list = empty_list + myform.elements[nme].value + " \n";
				}
			}
		}
		
		if (empty_list) {
				alert("Field Error: \n" + empty_list);
				return false;
			}
			else
				return true;
		
	}
	catch(err)
	{
		status = err.description + "\n\n";
		alert(status);
		return false;
	}
		
}

function wntyvalidgrc() {
	
	var empty_list = "";
	var myform = document.wntystatus;
	var status = "";

	try
	{
		for (x = 0; x<myform.repairstatus.length; x++) {
			if (myform.repairstatus[x].checked)
				status = myform.repairstatus[x].value;
		}
		
		if (!status)
			empty_list = empty_list + "No Warranty Status Selected \n";

  		if (status == "Warranty" || status == "Campaign" || status == "CUV" || status == "Goodwill")
		{
			if (!myform.elements["order[remanNbr]"].value)
				empty_list = empty_list + "Warranty Exchange is NOT allowed for model number " + myform.elements["order[PartNum]"].value + " \n \n If you wish to send this unit in for repair, return to our home page and follow the link to print a repair form. Fill out the form, attach it to the defective item, and mail it to the address listed on the form. \n  \n";
			
		}
		
		//if (myform.elements["part[pqcrequired]"].value == "Y")
		//	if (!myform.elements["part[PQCAuth]"].value)
		//		empty_list = empty_list + "PQC Authorization is required to continue. \n";
	
		if (empty_list) {
			alert("Field Error(s): \n \n" + empty_list);
			return false;
		}
		else
			return true;
			
	}
	catch(err)
	{
		status = err.description + "\n\n";
		alert(status);
		return false;
	}
}

function wntyvalidgrc2() {
	
	var empty_list = "";
	var myform = document.wntystatus;
	var status = "";

	try
	{
		for (x = 0; x<myform.order["RepairStatus"].length; x++) {
			if (myform.order["RepairStatus"][x].checked)
				status = myform.order["RepairStatus"][x].value;
		}
	
		if (!status)
			empty_list = empty_list + "No Warranty Status Selected \n";
		
		if (status == "Warranty" || status == "Campaign" || status == "CUV")
		{
			if (!myform.elements["part[remanNbr]"].value)
				empty_list = empty_list + "Warranty Exchange is NOT allowed for model number " + myform.elements["part[partnum]"].value + " \n \n If you wish to send this unit in for repair, return to our home page and follow the link to print a repair form. Fill out the form, attach it to the defective item, and mail it to the address listed on the form. \n  \n";
		}
		
		//if (myform.elements["part[pqcrequired]"].value == "Y")
		//	if (!myform.elements["part[PQCAuth]"].value)
		//		empty_list = empty_list + "PQC Authorization is required to continue. \n";
	
		if (empty_list) {
			alert("Field Error(s): \n \n" + empty_list);
			return false;
		}
		else
			return true;
			
	}
	catch(err)
	{
		status = err.description + "\n\n";
		alert(status);
		return false;
	}
}

function wntyvalidfr() {
	var empty_list = "";
	var myform = document.wntystatus;
	
	//if (!myform.elements[11].checked && !myform.elements[12].checked && !myform.elements[13].checked && !myform.elements[14].checked)
	//	empty_list = empty_list + "No Warranty Status Selected";
	
	//if (myform.elements[11].checked || myform.elements[13].checked)
	//	if (myform.elements["part[wntycode]"].value != "EXC")
	//		empty_list = empty_list + "Warranty Exchange is NOT allowed for model number " + myform.elements["part[partnum]"].value + " \n";
	
	//if (myform.elements[12].checked || myform.elements[14].checked)
	//	if (myform.elements["part[oowcode]"].value != "EXC")
	//		empty_list = empty_list + "Exchange is NOT allowed for model number " + myform.elements["part[partnum]"].value + " \n";
	
	if (empty_list) {
		alert("Field Error: \n" + empty_list);
		return false;
	}
	else
		return true;

}

function validatefr() {
	var empty_list = "";
	var myform = document.neworder;
	var wntystatus = myform.elements["order[RepairStatus]"].value;
	
	//	verify vin
	if (! myform.elements["order[VIN]"].value)
		empty_list = empty_list + "VIN Missing.\n";
	else if (! verify_length(myform.elements["order[VIN]"].value, "17", "17"))
		empty_list = empty_list + "VIN Must Be 17 Digits.\n";
//	else if (! myform.elements["override"].checked ) {
//		if (! validate_vin(myform.elements["order[VIN]"].value)) {
//			empty_list = empty_list + "VIN Is Invalid.\n";
//			document.getElementById('vin_override').innerHTML = '<i>Override Validation</i> <input type="checkbox" name="override" >';
//		}
	//}
	
	// verify mileage
	if (! myform.elements["order[Odometer]"].value)
		empty_list = empty_list + "Mileage Missing.\n";
	else if (! verify_numeric(myform.elements["order[Odometer]"].value, "any"))
		empty_list = empty_list + "Mileage Must Be Numeric.\n";

	// check ro #
	if (! myform.elements["order[RONumber]"].value)
		empty_list = empty_list + "RO # Missing.\n";
	else if (! verify_alphanumeric(myform.elements["order[RONumber]"].value, "6"))
		empty_list = empty_list + "RO # Must Be 6 Digit Alpha-mumeric.\n";
	
	if (! myform.elements["order[ROMonth]"].value)
		empty_list = empty_list + "Invalid Delivery Month. \n";
	if (! myform.elements["order[RODay]"].value)
		empty_list = empty_list + "Invalid Delivery Day. \n";
	if (! myform.elements["order[ROYear]"].value)
		empty_list = empty_list + "Invalid Delivery Year. \n";
	if (! myform.elements["order[DealerContactName]"].value)
		empty_list = empty_list + "Dealer Contact Name Missing. \n";
	if (! myform.elements["order[CustomerName]"].value)
		empty_list = empty_list + "Customer Name Missing. \n";
	if (! myform.elements["order[Complaint]"].value)
		empty_list = empty_list + "Product Failure Symptom Missing. \n";

	// for warranty status
	switch (wntystatus) {
		case "OutOfWarranty":
			if (! myform.elements["order[PONumber]"].value)
				empty_list = empty_list + "PO Number Missing. \n";
		break;
		case "ESP":
			if (! myform.elements["order[DeliveryMonth]"].value)
				empty_list = empty_list + "Invalid Delivery Month. \n";
			if (! myform.elements["order[DeliveryDay]"].value)
				empty_list = empty_list + "Invalid Delivery Day. \n";
			if (! myform.elements["order[DeliveryYear]"].value)
				empty_list = empty_list + "Invalid Delivery Year. \n";
			if (! myform.elements["order[ProductionMonth]"].value)
				empty_list = empty_list + "Invalid Production Month. \n";
			if (! myform.elements["order[ProductionDay]"].value)
				empty_list = empty_list + "Invalid Production Day. \n";
			if (! myform.elements["order[ProductionYear]"].value)
				empty_list = empty_list + "Invalid Production Year. \n";
			if (! myform.elements["order[ESPContractNumber]"].value)
				empty_list = empty_list + "ESP Contract Number Missing. \n";
			if (! myform.elements["order[ESP1878]"].value)
				empty_list = empty_list + "Form 1878 # Missing. \n";
			else if (! verify_length(myform.elements["order[ESP1878]"].value, "6", "8"))
				empty_list = empty_list + "1878# Must be 6-8 Alpha Numeric Characters.\n";
		break;
		case "Recheck":
			if (! myform.elements["order[DeliveryMonth]"].value)
				empty_list = empty_list + "Invalid Delivery Month. \n";
			if (! myform.elements["order[DeliveryDay]"].value)
				empty_list = empty_list + "Invalid Delivery Day. \n";
			if (! myform.elements["order[DeliveryYear]"].value)
				empty_list = empty_list + "Invalid Delivery Year. \n";
			if (! myform.elements["order[ProductionMonth]"].value)
				empty_list = empty_list + "Invalid Production Month. \n";
			if (! myform.elements["order[ProductionDay]"].value)
				empty_list = empty_list + "Invalid Production Day. \n";
			if (! myform.elements["order[ProductionYear]"].value)
				empty_list = empty_list + "Invalid Production Year. \n";
			if (! myform.elements["order[PreviousRONumber]"].value)
				empty_list = empty_list + "Previous RO # Missing. \n";
		break;
		case "Warranty":
			if (! myform.elements["order[DeliveryMonth]"].value)
				empty_list = empty_list + "Invalid Delivery Month. \n";
			if (! myform.elements["order[DeliveryDay]"].value)
				empty_list = empty_list + "Invalid Delivery Day. \n";
			if (! myform.elements["order[DeliveryYear]"].value)
				empty_list = empty_list + "Invalid Delivery Year. \n";
			if (! myform.elements["order[ProductionMonth]"].value)
				empty_list = empty_list + "Invalid Production Month. \n";
			if (! myform.elements["order[ProductionDay]"].value)
				empty_list = empty_list + "Invalid Production Day. \n";
			if (! myform.elements["order[ProductionYear]"].value)
				empty_list = empty_list + "Invalid Production Year. \n";
			if (! myform.elements["order[Warranty1878]"].value)
				empty_list = empty_list + "Form 1878 # Missing. \n";
			else if (! verify_length(myform.elements["order[Warranty1878]"].value, "6", "8"))
				empty_list = empty_list + "1878# Must be 6-8 Alph Numeric Characters.\n";
		break;
	}
	
if (empty_list) {
		alert("Field Error: \n" + empty_list);
		return false;
	}
	else
		return true;
	
}

function wntyvalidgpqc() {
	var empty_list = "";
	var myform = document.wntystatus;
	
	if (!myform.elements[21].checked && !myform.elements[22].checked && !myform.elements[23].checked)
		empty_list = empty_list + "No Warranty Status Selected \n";
	
	if (myform.elements["part[wntycode]"].value != "EXC")
		empty_list = empty_list + "Warranty Exchange is NOT allowed for model number " + myform.elements["part[partnum]"].value + " \n If you wish to send this unit in for repair, return to our home page and follow the link to print a repair form. Fill out the form, attach it to the defective item, and mail it to the address listed on the form. \n  \n";
	
	if (!myform.elements["part[PQCAuth]"].value)
		empty_list = empty_list + myform.elements["part[VIN]"].value + "     PQC Authorization is required to continue. \n";

	if (empty_list) {
		alert("Field Error(s): \n \n" + empty_list);
		return false;
	}
	else
		return true;

}

function mytest() {
	
	var empty_list = "";
	var myform = document.wntystatus;
	
	//  verify make
	if (myform.elements["question[q136]"].value == 0)
		empty_list = empty_list + "Make required.\n";
	
	//  verify model
	if (myform.elements["question[q137]"].value == 0)
		empty_list = empty_list + "Model required.\n";
	
	//  verify model year
	if (myform.elements["question[q136]"].value == 0)
		empty_list = empty_list + "Model Year required.\n";
	
	//	verify vin
	if (! myform.elements["question[q64]"].value)
		empty_list = empty_list + "VIN Missing.\n";
	else if (! verify_length(myform.elements["question[q64]"].value, "17", "17"))
		empty_list = empty_list + "VIN Must Be 17 Digits.\n";
	
	// verify mileage
	if (! myform.elements["question[q65]"].value)
		empty_list = empty_list + "Mileage Missing.\n";
	else if (! verify_numeric(myform.elements["question[q65]"].value, "any"))
		empty_list = empty_list + "Mileage Must Be Numeric.\n";

	// check ro #
	if (! myform.elements["question[q62]"].value)
		empty_list = empty_list + "RO # Missing.\n";
	else if (! verify_alphanumeric(myform.elements["question[q62]"].value, "6"))
		empty_list = empty_list + "RO # Must Be 6 Digit Alpha-mumeric.\n";

	if (! myform.elements["question[romonth]"].value)
		empty_list = empty_list + "Invalid Delivery Month. \n";
	if (! myform.elements["question[roday]"].value)
		empty_list = empty_list + "Invalid Delivery Day. \n";
	if (! myform.elements["question[royear]"].value)
		empty_list = empty_list + "Invalid Delivery Year. \n";
	if (! myform.elements["question[q68]"].value)
		empty_list = empty_list + "Dealer Contact Name Missing. \n";
	if (! myform.elements["question[q74]"].value)
		empty_list = empty_list + "Product Failure Symptom Missing. \n";
	if (! myform.elements["question[deliverymonth]"].value)
		empty_list = empty_list + "Invalid Delivery Month. \n";
	if (! myform.elements["question[deliveryday]"].value)
		empty_list = empty_list + "Invalid Delivery Day. \n";
	if (! myform.elements["question[deliveryyear]"].value)
		empty_list = empty_list + "Invalid Delivery Year. \n";
	
	if (empty_list) {
		alert("Field Error: \n" + empty_list);
		return false;
	}
	else
		return true;
	
}

function mytest2() {
	var empty_list = "";
	var myform = document.neworder;
	var msg = "";
	var nm = "";
	var nme = "";
	var strVar = "";

	try
	{
		empty_list = "Results: \n";
		
		//if (myform.elements["order[ProgReq]"].length)
		//	return "this is an array \n";
			
		if (myform.elements["sapProgReq"].value == "Inquire")
		{
			if (! myform.elements["order[ProgReq]"].value)
				empty_list = empty_list + "Do you want Techni-Car to program this part for you? \n";
			else
				strVar = myform.elements["order[ProgReq]"].value;
				
		}

		if (strVar == "1" || myform.elements["sapProgReq"].value == "Yes")
		{
			if (! myform.elements["order[EngHrsReq]"].value)
				empty_list = empty_list + "Does vehicle required Service Engine Hours to be programmed? \n";
			else
			{
				strVar = myform.elements["order[EngHrsReq]"].value;
				if (strVar == "1")
					if (! myform.elements["order[ServiceEngineHrs]"].value)
						empty_list = empty_list + "Service Engine Hours Missing. \n";
			}
		}
		
		if (empty_list) {
			alert(empty_list);
			return false;
		}
		else
			return false;
	}
	catch(err)
	{
		msg = err.description + " \n";
		alert(msg);
		return false;
	}
		
}

function validatepqcr() {
	var empty_list = "";
	var myform = document.pqc;
	
	// verify make
	///if (myform.elements["question[q139]"].value == 0)
	//	empty_list = empty_list + "Make Required. \n";
	
	// verify make
	///if (myform.elements["question[q140]"].value == 0)
	//	empty_list = empty_list + "Model required. \n";
	
	// verify make
	///if (! myform.elements["question[q141]"].value)
	//	empty_list = empty_list + "Model Year required. \n";

	// check ro #
	if (! myform.elements["question[q3]"].value)
		empty_list = empty_list + "RO # Missing.\n";
	else if (! verify_alphanumeric(myform.elements["question[q3]"].value, "6"))
		empty_list = empty_list + "RO # Must Be 6 Digit Alpha-mumeric.\n";

	if (! myform.elements["question[q11]"].value)
		empty_list = empty_list + "Service Tech Name required. \n";
	
	if (! myform.elements["question[q12]"].value)
		empty_list = empty_list + "Service Tech Phone Number required. \n";
	

	if (empty_list) {
		alert("Field Error: \n" + empty_list);
		return false;
	}
	else
		return true;
}

function validatepqcc() {
	var empty_list = "";
	var myform = document.pqc_cluster;

	// verify make
	// if (myform.elements["question[q136]"].value == 0)
	// 	empty_list = empty_list + "Make Required. \n";
	
	// verify make
	// if (myform.elements["question[q137]"].value == 0)
	// 	empty_list = empty_list + "Model required. \n";
	
	// verify make
	// if (! myform.elements["question[q138]"].value)
	// 	empty_list = empty_list + "Model Year required. \n";

	// check ro #
	if (! myform.elements["question[q62]"].value)
		empty_list = empty_list + "RO # Missing.\n";
	else if (! verify_alphanumeric(myform.elements["question[q62]"].value, "6"))
		empty_list = empty_list + "RO # Must Be 6 Digit Alpha-mumeric.\n";
		
	if (! myform.elements["question[q70]"].value)
		empty_list = empty_list + "Service Tech Name required. \n";
	
	if (! myform.elements["question[q71]"].value)
		empty_list = empty_list + "Service Tech Phone Number required. \n";
	
	if (!myform.elements["question[s27]"].checked && !myform.elements["question[s28]"].checked && !myform.elements["question[s29]"].checked && !myform.elements["question[s30]"].checked && !myform.		elements["question[s31]"].checked)
		empty_list = empty_list + "At least one Problem Type must be selected. \n";

	if (! myform.elements["question[q74]"].value)
		empty_list = empty_list + "Customer Complaint required. \n";

	if (!myform.elements["question[q225yes]"].checked && !myform.elements["question[q225no]"].checked)
		empty_list = empty_list + "Section B Question 2 requires a response. \n";

	if (empty_list) {
		alert("Field Error: \n" + empty_list);
		return false;
	}
	else
		return true;
}

function validatekv() {
	var empty_list = "";
	var myform = document.neworder;
	var wntystatus = myform.elements["order[RepairStatus]"].value;
	
	//	verify vin
	if (! myform.elements["order[VIN]"].value)
		empty_list = empty_list + "VIN Missing.\n";
	else if (! verify_length(myform.elements["order[VIN]"].value, "17", "17"))
		empty_list = empty_list + "VIN Must Be 17 Digits.\n";
//	else if (! myform.elements["override"].checked ) {
//		if (! validate_vin(myform.elements["order[VIN]"].value)) {
//			empty_list = empty_list + "VIN Is Invalid.\n";
//			document.getElementById('vin_override').innerHTML = '<i>Override Validation</i> <input type="checkbox" name="override" >';
// 		}
	// }
	
	// verify mileage
	if (! myform.elements["order[Odometer]"].value)
		empty_list = empty_list + "Mileage Missing.\n";
	else if (! verify_numeric(myform.elements["order[Odometer]"].value, "any"))
		empty_list = empty_list + "Mileage Must Be Numeric.\n";
	
	// check for PQC, if so check for authorization.
	if (myform.elements["order[pqclevel]"].value != 0)
		if  (!myform.elements["order[PQCAuth]"].value)
			empty_list = empty_list + "PQC Authorization Required!\n";
			
	// check ro #
	if (! myform.elements["order[RONumber]"].value)
		empty_list = empty_list + "RO # Missing.\n";
	else if (! verify_alphanumeric(myform.elements["order[RONumber]"].value, "6"))
		empty_list = empty_list + "RO # Must Be 6 Digit Alpha-mumeric.\n";
	
	if (! myform.elements["order[ROMonth]"].value)
		empty_list = empty_list + "Invalid Delivery Month. \n";
	if (! myform.elements["order[RODay]"].value)
		empty_list = empty_list + "Invalid Delivery Day. \n";
	if (! myform.elements["order[ROYear]"].value)
		empty_list = empty_list + "Invalid Delivery Year. \n";
	if (! myform.elements["order[DealerContactName]"].value)
		empty_list = empty_list + "Dealer Contact Name Missing. \n";
	if (! myform.elements["order[CustomerName]"].value)
		empty_list = empty_list + "Customer Name Missing. \n";
	if (! myform.elements["order[Complaint]"].value)
		empty_list = empty_list + "Product Failure Symptom Missing. \n";

	// for warranty status
	switch (wntystatus) {
		case "OutOfWarranty":
			if (! myform.elements["order[PONumber]"].value)
				empty_list = empty_list + "PO Number Missing. \n";
		break;
		case "Recheck":
			if (! myform.elements["order[DeliveryMonth]"].value)
				empty_list = empty_list + "Invalid Delivery Month. \n";
			if (! myform.elements["order[DeliveryDay]"].value)
				empty_list = empty_list + "Invalid Delivery Day. \n";
			if (! myform.elements["order[DeliveryYear]"].value)
				empty_list = empty_list + "Invalid Delivery Year. \n";
			if (! myform.elements["order[PreviousRONumber]"].value)
				empty_list = empty_list + "Previous RO # Missing. \n";
		break;
		case "Warranty":
			if (! myform.elements["order[DeliveryMonth]"].value)
				empty_list = empty_list + "Invalid Delivery Month. \n";
			if (! myform.elements["order[DeliveryDay]"].value)
				empty_list = empty_list + "Invalid Delivery Day. \n";
			if (! myform.elements["order[DeliveryYear]"].value)
				empty_list = empty_list + "Invalid Delivery Year. \n";
		break;
	}
	
if (empty_list) {
		alert("Field Error: \n" + empty_list);
		return false;
	}
	else
		return true;
}

function wntyvalidcdmk() 
{
	
	var empty_list = "";
	var myform = document.wntystatus;
	var status = "";

	try
	{
		for (x = 0; x<myform.repairstatus.length; x++) {
			if (myform.repairstatus[x].checked)
				status = myform.repairstatus[x].value;
		}
	
		if (!status)
			empty_list = empty_list + "No Warranty Status Selected \n";
		
		if (empty_list) {
			alert("Field Error(s): \n \n" + empty_list);
			return false;
		}
		else
			return true;
			
	}
	catch(err)
	{
		status = err.description + "\n\n";
		alert(status);
		return false;
	}
}

function validatecdmk() 
{
	var empty_list = "";
	var strVar = "";
	var myform = document.neworder;
	var wntystatus = myform.elements["order[RepairStatus]"].value;

	try
	{
		alert("got here");
		return false;
		
		//	verify vin
		if (myform.elements["order[VIN]"].value)
			if (! verify_length(myform.elements["order[VIN]"].value, "0", "17"))
				empty_list = empty_list + "VIN Must Be no greater than 17 Digits.\n";
		
		// verify mileage
		if (myform.elements["order[Odometer]"].value)
		{
			if (! verify_numeric(myform.elements["order[Odometer]"].value, "any"))
				empty_list = empty_list + "Mileage Must Be Numeric.\n";
			else if (! verify_length(myform.elements["order[Odometer]"].value, "0", "7"))
				empty_list = empty_list + "Mileage Must Be no greater than 7 Digits.\n";
		}
		
		// check ros claim #
		if (! myform.elements["order[GWAuth]"].value)
			empty_list = empty_list + "ROS Claim # Missing.\n";
		else if (! verify_length(myform.elements["order[GWAuth]"].value, "11", "11"))
			empty_list = empty_list + "ROS Claim # must be at 11 digits long.\n";
		else if (! verify_alphanumeric(myform.elements["order[GWAuth]"].value, "any"))
			empty_list = empty_list + "ROS Claim # must be Alpha-mumeric.\n";
		
		// verify model
		if (myform.elements["order[Model]"].value)
		{
			if (! verify_alphanumeric(myform.elements["order[Model]"].value, "any"))
				empty_list = empty_list + "Vehicle Model Must Be Alpha-mumeric.\n";
			else if (! verify_length(myform.elements["order[Model]"].value, "0", "30"))
				empty_list = empty_list + "Vehicle Model Must Be no greater than 30 Digits.\n";
		}
		
		// verify contact name
		if (myform.elements["order[DealerContactName]"].value)
		{
			if (! verify_alphanumeric(myform.elements["order[DealerContactName]"].value, "any"))
				empty_list = empty_list + "Contact Name Must Be Alpha-mumeric.\n";
			else if (! verify_length(myform.elements["order[DealerContactName]"].value, "0", "30"))
				empty_list = empty_list + "Contact Name Must Be no greater than 30 Digits.\n";
		}
		
		// verify complaint
		if (! myform.elements["order[Complaint]"].value)
			empty_list = empty_list + "Product Failure Symptom Missing.\n";
		
		if (empty_list) {
				alert("Field Error: \n" + empty_list);
				return false;
			}
			else
				return true;
		
	}
	catch(err)
	{
		status = err.description + "\n\n";
		alert(status);
		return false;
	}
		
}


function callAjax(obj)
{
    if($('#'+obj).is(':checked'))
   {
       $('#order[GWAuth]').val('something');
   }
   else
   {
       $('#order[GWAuth]').val('');
   }

}

function mytest3() {
	var myform = document.neworder;
	var msg = "";
	
	try
	{
		msg = "Results: \n";

		var data = myform.elements["order[RODate]"].value;
		
		regex = /^(\d{1,2})\/(\d{1,2})\/(\d{2,4})$/.test(data);
		if (regex){
			var myDateParts = data.split("/");
			var myYear = myDateParts[2];
			if (myYear < 1000) {
				if (myYear < 50)
					myYear = '20' + myYear;
				else
					myYear = '19' + myYear;
			}
			var d = new Date(myYear, myDateParts[0]-1, myDateParts[1]);
			if ((d.getFullYear() == myYear) && (d.getMonth() + 1 == myDateParts[0]) && (d.getDate() == myDateParts[1]))
				msg = msg + "Good date \n";										  
			//msg = msg + "myYear = " + myYear + " \n";										  
		}
		else
			msg = msg + myform.elements["order[RODate]"].value + " Invalid RO Date. \n";										  

		if (msg) {
			alert(msg);
			return false;
		}
		else
			return false;
	}
	catch(err)
	{
		msg = err.description + " \n";
		alert(msg);
		return false;
	}
		
	function showmodels(make, model) {
		
		alert(make);
		return;
		
		if (make=="")
			{
				document.getElementById("ddModels").innerHTML="";
				return;
			}

		if (window.XMLHttpRequest)
			{// code for IE7+, Firefox, Chrome, Opera, Safari
				xmlhttp=new XMLHttpRequest();
			}
			else
			{// code for IE6, IE5
				xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
			}

		xmlhttp.onreadystatechange=function() {
		  	if (xmlhttp.readyState==4 && xmlhttp.status==200)
			{
				document.getElementById("ddModels").innerHTML=xmlhttp.responseText;
			}
		}
		
		xmlhttp.open("GET","getmodels.php?m="+make+"&v="+model,true);
		
		xmlhttp.send();
	}
	//
	// http://roshanbh.com.np/2007/12/change-dropdown-list-options-values-from-database-with-ajax-and-php.html
	function getCity(strURL)
    {         
     	var req = getXMLHTTP(); // fuction to get xmlhttp object
     	if (req)
     	{
     		req.onreadystatechange = function()
	     	{
				if (req.readyState == 4) { //data is retrieved from server
					if (req.status == 200) { // which reprents ok status                    
						document.getElementById('ddModels').innerHTML=req.responseText;
					}
					else
					{ 
						alert("There was a problem while using XMLHTTP:\n");
					}
				}            
	     	}        
		    req.open("GET", strURL, true); //open url using get method
    		req.send(null);
	    }
    }
}
// -->
