<!--

function Left(str, n){
	if (n <= 0)
	    return "";
	else if (n > String(str).length)
	    return str;
	else
	    return String(str).substring(0,n);
}
function Right(str, n){
    if (n <= 0)
       return "";
    else if (n > String(str).length)
       return str;
    else {
       var iLen = String(str).length;
       return String(str).substring(iLen, iLen - n);
    }
}

function validate_vin(strVIN) {
	var strVIN = strVIN.toUpperCase();
	var lngSubTotal = 0;
	for (Idx=0; Idx<17; Idx++) {
		if (Idx != 8) {
			switch(Idx+1) {
				case 1: 
				case 11:
					var intWF = 8;
					break;
				case 2:
				case 12:
					var intWF = 7;
					break;
				case 3:
				case 13:
					var intWF = 6;
					break;
				case 4:
				case 14:
					var intWF = 5;
					break;
				case 5:
				case 15:
					var intWF = 4;
					break;
				case 6:
				case 16:
					var intWF = 3;
					break;
				case 7:
				case 17:
					var intWF = 2;
					break;
				case 8:
					var intWF = 10;
					break;
				case 10:
					var intWF = 9;
			}
			switch(strVIN.charAt(Idx)) {
				case "1":
				case "A":
				case "a":
				case "J":
				case "j":
					var intNV = 1;
					break;
				case "2":
				case "B":
				case "b":
				case "K":
				case "k":
				case "S":
				case "s":
					var intNV = 2;
					break;
				case "3":
				case "C":
				case "L":
				case "T":
					var intNV = 3;
					break;
				case "4":
				case "D":
				case "M":
				case "U":
					var intNV = 4;
					break;
				case "5":
				case "E":
				case "N":
				case "V":
					var intNV = 5;
					break;
				case "6":
				case "F":
				case "W":
					var intNV = 6;
					break;
				case "7":
				case "G":
				case "P":
				case "X":
					var intNV = 7;
					break;
				case "8":
				case "H":
				case "Y":
					var intNV = 8;
					break;
				case "9":
				case "R":
				case "Z":
					var intNV = 9;
					break;
				default:
					var intNV = 0;
			}
			lngSubTotal = lngSubTotal+(intNV*intWF);
		}
	}
	intCalcCD = lngSubTotal % 11;
	if (intCalcCD == 10)
		strCalcCD = "X";
	else
		strCalcCD = intCalcCD.toString();
	strVINCD = strVIN.charAt(8);
	if (strCalcCD == strVINCD)
		return true;
	else
		return false;
}

function verify_alphanumeric(data, length) {
	regex = /(^[0-9a-zA-Z]+$)/.test(data);
	if (regex) {
		if (length=="any")
			return true;
		else if (data.length == length)
			return true;
	}
	return false;
}

function verify_numeric(data, length) {
	regex = /(^\d+$)/.test(data);
	if (regex) {
		if (length=="any")
			return true;
		else if (data.length == length)
			return true;
	}
	return false;
}

function verify_length(data, low, high) {
	if ((data.length >= low) && (data.length <= high))
		return true;
	else
		return false;
}

function verify_date(data) {
	regex = /^(\d{1,2})\/(\d{1,2})\/(\d{2,4})$/.test(data);
	if (regex){
		var myDateParts = data.split("/");
		var myYear = myDateParts[2];
		if (myYear < 1000) {
			if (myYear < 50)
				myYear = '20' + myYear;
			else
				myYear = '19' + myYear;
		}
		var d = new Date(myYear, myDateParts[0]-1, myDateParts[1]);
		var now = new Date();
		if ((d.getFullYear() == myYear) && (d.getMonth() + 1 == myDateParts[0]) && (d.getDate() == myDateParts[1])) {
			if (d <= now)
				return true;
		}
	}
	return false;
}

function validatecdmk() 
{
	var empty_list = "";
	var strVar = "";
	var myform = document.neworder;
	var wntystatus = myform.elements["order[RepairStatus]"].value;

	try
	{

		//	verify vin
		if (myform.elements["order[VIN]"].value)
			if (! verify_length(myform.elements["order[VIN]"].value, "0", "17"))
				empty_list = empty_list + "VIN Must Be no greater than 17 Digits.\n";
		
		// verify mileage
		if (myform.elements["order[Odometer]"].value)
		{
			if (! verify_numeric(myform.elements["order[Odometer]"].value, "any"))
				empty_list = empty_list + "Mileage Must Be Numeric.\n";
			else if (! verify_length(myform.elements["order[Odometer]"].value, "0", "7"))
				empty_list = empty_list + "Mileage Must Be no greater than 7 Digits.\n";
		}
		
		// check ros claim #
		if (! myform.elements["order[GWAuth]"].value)
			empty_list = empty_list + "ROS Claim # Missing.\n";
		else if (! verify_length(myform.elements["order[GWAuth]"].value, "11", "11"))
			empty_list = empty_list + "ROS Claim # must be at 11 digits long.\n";
		else if (! verify_alphanumeric(myform.elements["order[GWAuth]"].value, "any"))
			empty_list = empty_list + "ROS Claim # must be Alpha-mumeric.\n";
		
		// verify model
		if (myform.elements["order[Model]"].value)
		{
			if (! verify_alphanumeric(myform.elements["order[Model]"].value, "any"))
				empty_list = empty_list + "Vehicle Model Must Be Alpha-mumeric.\n";
			else if (! verify_length(myform.elements["order[Model]"].value, "0", "30"))
				empty_list = empty_list + "Vehicle Model Must Be no greater than 30 Digits.\n";
		}
		
		// verify contact name
		if (myform.elements["order[DealerContactName]"].value)
		{
			if (! verify_alphanumeric(myform.elements["order[DealerContactName]"].value, "any"))
				empty_list = empty_list + "Contact Name Must Be Alpha-mumeric.\n";
			else if (! verify_length(myform.elements["order[DealerContactName]"].value, "0", "30"))
				empty_list = empty_list + "Contact Name Must Be no greater than 30 Digits.\n";
		}
		
		// verify complaint
		if (! myform.elements["order[Complaint]"].value)
			empty_list = empty_list + "Product Failure Symptom Missing.\n";
		
		if (empty_list) {
				alert("Field Error: \n" + empty_list);
				return false;
			}
			else
				return true;
		
	}
	catch(err)
	{
		status = err.description + "\n\n";
		alert(status);
		return false;
	}
		
}

// -->
