<?PHP
// 7/4/11
function verify_alphanumeric($data) {
	if(!preg_match("/[^A-Za-z0-9]/", $data))
		return true;
	else 
		return false;
}

function verify_length($data, $low, $high) {
	if ((strlen($data) >= $low) && (strlen($data) <= $high))
		return true;
	else
		return false;
}

function verify_date($data)
{
	//return true;
	$curdate= strtotime(date("m/d/y"));
	
	$mydate = strtotime( $data );
	if (is_numeric($mydate))
	{
		$Month = date( 'm', $mydate );
		$Day   = date( 'd', $mydate );
		$Year  = date( 'Y', $mydate );
	}
	else
		return false;
	
	
	if (checkdate( $Month, $Day, $Year ))
	{
		if ($mydate <= $curdate)
			return true;
		else
			return false;
	}
	else 
		return false;
}

function validategrc($order, $tidi_fields, $tidierr, $tidi_date_fields) {
	global $SAPDBNAME;
	$err_list = "";
	$strVar = "";
	$wnty = "";
	$wntystatus = $order['RepairStatus'];
	
	try
	{
		//	verify vin
		if (empty($order['VIN']))
			$err_list .= "VIN Missing.<br/>";
		else if (strlen($order['VIN']) != 17)
			$err_list .= "VIN Must Be 17 Digits.<br/>";

		// verify mileage
		if (empty($order['Odometer']))
			$err_list .= "Odometer Reading Missing.<br/>";
		else if (!is_numeric($order['Odometer']))
			$err_list .= "Odometer Reading Must Be Numeric.<br/>";
		
		if (empty($order['U_MileageInd']))
			$err_list .= "Invalid Odometer Type. <br/>";
			
				
		// check ro #
		if (empty($order['RONumber']))
			$err_list .= "RO # Missing.<br/>";
		else if (! verify_length($order['RONumber'], "6", "8"))
			$err_list .= "RO # must be at least 6 and no more than 8 digits long.<br/>";
		else if (! verify_alphanumeric($order['RONumber']))
			$err_list .= "RO # must be Alpha-mumeric.<br/>";
		
		if (!verify_date($order['RODate']))
			$err_list .= "Invalid RO Date. <br/>";
		
		if (! verify_length($order['DealerContactName'], "20", "20"))
			$err_list .= "Dealer Contact Name Missing. <br/>";
		if (strlen($order['DealerContactName']) > 20)
			$err_list .= "Dealer Contact Name Must Be Less Than 20 Characters. <br/>";
		if (empty($order['CustomerName']))
			$err_list .= "Customer Name Missing. <br/>";
		if (empty($order['Complaint']))
			$err_list .= "Product Failure Symptom Missing. <br/>";
	
		// for warranty status
		switch ($wntystatus) {
			case "OutOfWarranty":
				if (empty($order['PONumber']))
				$err_list .= "PO Number Missing. <br/>";
			break;
			case "Warranty":
				$wnty = "y";
				if (!verify_date($order['DeliveryDate']))
					$err_list .= "Invalid Delivery Date. <br/>";
				if (empty($order['U_ObtainVia']))
					$err_list .= "Part Number Obtained From Required.<br/>";
			break;
			case "Campaign":
				$wnty = "y";
				if (!verify_date($order['DeliveryDate']))
					$err_list .= "Invalid Delivery Date. <br/>";
				if (empty($order['U_ObtainVia']))
					$err_list .= "Part Number Obtained From Required.<br/>";
			break;
			case "CUV":
				$wnty = "y";
				if (!verify_date($order['DeliveryDate']))
					$err_list .= "Invalid Delivery Date. <br/>";
				if (empty($order['U_ObtainVia']))
					$err_list .= "Part Number Obtained From Required.<br/>";
			break;
		}

		if ($order['Goodwill'] == '1')
			if (empty($order['GWAuth']))
					$err_list .= "Goodwill Authorization Missing. <br/>";
		
		if ($order['recheckYN'] == "Yes")
				if (empty($order['PreviousRONumber']))
					$err_list .= "Previous RO # Missing. <br/>";

		if ($order['EngHrsReq'] == 0)
			$err_list .= "Does vehicle required Service Engine Hours to be programmed? Requires an answer.<br />";
		else
		{
			$strVar = $order['EngHrsReq'];
			if ($strVar == "1")
			{
				if (empty($order['ServiceEngineHrs']))
					$err_list .= "Service Engine Hours Missing. <br />";
				else if (!is_numeric($order['ServiceEngineHrs']))
					$err_list .= "Service Engine Hours Must Be Numeric.<br/>";
			}		
		}
		
		$tacFieldExists = "";
		// check for PQC, if so check for authorization.
		if ($order['pqclevel'] == 1)
			if  (empty($order['PQCAuth']))
				$err_list .= "PQC Authorization Required!<br/>";
		
		if (!empty($tidi_fields))
		{
			foreach($tidi_fields as $tidi_field)
			{
				if ($tidi_field == 'TacCaseNum')
					$tacFieldExists = 'yes';
					
				if (empty($order[$tidi_field]))
					if ($tidi_field != 'ServiceEngineHrs')
						$err_list .= $tidierr[$tidi_field]." <br />";
			}
							
			if (empty($err_list))
			{
				if (!empty($tidi_date_fields))
				{
					foreach($tidi_date_fields as $tidi_field)
					{
						if (!verify_date($order[$tidi_field]))
							$err_list .= $tidierr[$tidi_field]." <br />";
					}
				}
			}
		}
		
		// check to see if the tac number tidi already exists 
		if (empty($tacFieldExists))
		{
			if (!empty($wnty))
			{
				if (!empty($order['RadioTACTidi']))
				{
					//check to see if radio has been here within the last six months
					$query = "select o.docnum
					from [SAPSQL].".$SAPDBNAME.".[dbo].ordr o inner join [SAPSQL].[".$SAPDBNAME."].[dbo].rdr1 d (nolock) on o.DocEntry = d.DocEntry
					inner join [SAPSQL].".$SAPDBNAME.".[dbo].[@LBSICEMSTR] c (nolock) on o.DocNum=c.[U_SO_DocNum]
					where o.[U_VinNbr]='".$order['VIN']."' and (d.ItemCode='".$order['PartNumInVeh']."' or d.[U_ReqItem]='".$order['PartNumInVeh']."' 
					or o.[U_DealerAlt]='".$order['PartNumInVeh']."') and o.U_Shipperdeldate >= dateadd(d, -180, getdate())
					and c.[U_ReturnUnused] <> 'y'";

					$result = get_sap_record($query);
					
					if (!empty($result))
					{
						if (empty($order['TacCaseNum']))
						{
							$_SESSION['tacreq'] = 'yes';
							$err_list .= "Recheck within 6 months of previous repair or exchange. TAC Case Number Required. <br />";
						}
					}
				}
			}
		}
	}
	catch(Exception $err)
	{
		$err_list .= "Captured Error : ".$err->getMessage() + " <br/>";
	}

	if (!empty($err_list))
		$rtnVal = "<p><font color=red>".$err_list."</font></p>";
	else
		$rtnVal = "";
		
	return $rtnVal;
}


?>