<?PHP
if (!session_id())
	session_start();
include_once("inc/inc.php");
require('inc/fpdf.php');

class PDF extends FPDF
{
	var $ftr;
	
	// Page header
	function Header()
	{
		$query = "SELECT *
		FROM tci_GetInvoiceHeader
		WHERE InvoiceNumber=".$_GET['inv'];
//print "got here";
		$inv = getinvoiceheader($_GET['inv']);
		//$this->$inv=get_sap_record($query);
//print "got here 3";
		// Logo
		$this->Image('images/technicar.png',10,6,80,20);
		// Arial bold 15
		$this->SetFont('Arial','B',15);
		// Move to the right
		$this->Cell(130);
		// Set text color to white
		$this->SetTextColor(255,255,255);
		// Set the fill color
		$this->SetFillColor(0,0,0);
		// Title
		$won = $_GET['won'];
		$this->Cell(60,10,'INVOICE',1,1,'C',true);
		// Line break
		$this->Ln(8);
		// Set text color to black
		$this->SetTextColor(0,0,0);
		// Set font to Arial bold 6
		$this->SetFont('Arial','',10);
	
		$this->Cell(40,5,'450 Commerce Blvd.',0,0,'L');
		$this->Cell(40,5,'PH: (800) 886-0022',0,0,'R');
		$this->SetFont('Arial','B',12);
		$this->Cell(70,5,'Invoice #:',0,0,'R');
		$this->Cell(40,5,$inv['InvoiceNumber'],0,1,'R');
	
		$this->SetFont('Arial','',10);
		$this->Cell(40,5,'Oldsmar, FL 34677',0,0,'L');
		$this->Cell(40,5,'FAX: (813) 855-2101',0,0,'R');
		$this->SetFont('Arial','',12);
		$this->Cell(70,5,'Invoice Date:',0,0,'R');
		$this->Cell(40,5,$inv['DocDate'],0,1,'R');
			
	$this->Cell(40,5,'www.techni-car.com',0,0,'L');
	$this->Cell(40,5,'csr@techni-car.com',0,1,'R');

	
		// Line Break
		$this->Ln(10);
		$addr = str_replace(chr(13),"\n", $inv['Address']);
		$addr = trim($inv['PayToCode'])."\n".str_replace("\n\n","\n",$addr);
		$addr2 = str_replace(chr(13),"\n", $inv['Address2']);
		$addr2 = trim($inv['ShipToCode'])."\n".str_replace("\n\n","\n",$addr2);
		$this->SetFont('Arial','B',10);
		$this->Cell(95,6,'Bill To:',1,0,'L');
		$this->Cell(95,6,'Ship To:',1,1,'L');
		$this->SetFont('Arial','',10);
		//Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,95,26);
        //Print the text
        $this->MultiCell(95,5,$addr,0,'L');
        //Put the position to the right of the cell
        $this->SetXY($x+95,$y);
        //Draw the border
        $this->Rect($x+95,$y,95,26);
		//Print the text
        $this->MultiCell(95,5,$addr2,0,'L');
		//Position to the top right of the reamining cells
        $this->SetXY($x,$y+26);

		$this->SetFont('Arial','B',10);
		$this->Cell(40,6,'Purchase Order',1,0,'L');
		$this->Cell(40,6,'Repair Order',1,0,'L');
		$this->Cell(55,6,'Customer Name',1,0,'L');
		$this->Cell(55,6,'VIN',1,1,'L');
		
		$this->SetFont('Arial','',10);
		$this->Cell(40,6,$inv['NumAtCard'],'LT',0,'L');
		$this->Cell(40,6,$inv['U_DlrReprOrdr'],'LT',0,'L');
		$this->Cell(55,6,$inv['U_CustLastName'],'LT',0,'L');
		$this->Cell(55,6,$inv['U_VinNbr'],'LTR',1,'L');
		$this->SetFont('Arial','',10);
		$this->Cell(40,6,'','LB',0,'L');
		$this->Cell(40,6,'','LB',0,'L');
		$this->Cell(55,6,'','LB',0,'L');
		$this->Cell(55,6,'','LBR',1,'L');
		
		$this->SetFont('Arial','B',10);
		$this->Cell(40,6,'Customer #',1,0,'L');
		$this->Cell(40,6,'Dealer Code',1,0,'L');
		$this->Cell(55,6,'Ordered By',1,0,'L');
		$this->Cell(55,6,'Terms',1,1,'L');
		
		$this->SetFont('Arial','',10);
		$this->Cell(40,6,$inv['CardCode'],'LT',0,'L');
		$this->Cell(40,6,$inv['U_DealerPA'],'LT',0,'L');
		$this->Cell(55,6,$inv['U_ContactLName'],'LT',0,'L');
		$this->Cell(55,6,$inv['PymntGroup'],'LTR',1,'L');
		$this->SetFont('Arial','',10);
		$this->Cell(40,6,'','LB',0,'L');
		$this->Cell(40,6,'','LB',0,'L');
		$this->Cell(55,6,'','LB',0,'L');
		$this->Cell(55,6,'','LBR',1,'L');
		
		$this->SetFont('Arial','B',10);
		$this->Cell(40,6,'Sales Order',1,0,'L');
		$this->Cell(40,6,'Date Shipped',1,0,'L');
		$this->Cell(55,6,'Shipped Via',1,0,'L');
		$this->Cell(55,6,'Tracking',1,1,'L');
		
		$this->SetFont('Arial','',10);
		$this->Cell(40,6,$inv['SONum'],'LT',0,'L');
		$this->Cell(40,6,$inv['DateSent'],'LT',0,'L');
		$this->Cell(55,6,$inv['TrnspName'],'LT',0,'L');
		$this->Cell(55,6,$inv['U_LBSICETrackOut'],'LTR',1,'L');
		$this->SetFont('Arial','',10);
		$this->Cell(40,6,'','LB',0,'L');
		$this->Cell(40,6,'','LB',0,'L');
		$this->Cell(55,6,'','LB',0,'L');
		$this->Cell(55,6,'','LBR',1,'L');
		
		// Line Break
		$this->Ln(3);
	}
	
	// Page footer
	function Footer()
	{
		// Position at 1.5 cm from bottom
		$this->SetY(-45);
		// Arial italic 8
		$this->SetFont('Arial','I',12);
		//$this->Cell(0,10,$this->ftr,0,1,'L');
		$this->Write(4, $this->ftr);
		$this->Cell(1,1,'',0,1,'L');
		$this->Ln(5);
		$this->Cell(190,6, 'THANK YOU FOR YOUR BUSINESS','T',1,'C');
		$this->SetY(-15);
		// Page number
		$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'R');
	}
}

$User = get_user_info();
//$query = "SELECT *
//FROM tci_GetInvoiceBody
//WHERE InvoiceNumber=".$_GET['inv'];
//$inv = get_sap_record($query);
$inv = getinvoicebody($_GET['inv']);
//print "gothere";
// Create the pdf
$pdf = new PDF();
// get the order detail from SAP
$pdf->AliasNbPages();
$pdf->AddPage('P','Letter');

		// set the text color to white
		$pdf->SetTextColor(255,255,255);
		// Set the fill color to black
		$pdf->SetFillColor(0,0,0);

		$pdf->SetFont('Arial','B',10);
		$pdf->Cell(20,6,'Quantity',1,0,'L',true);
		$pdf->Cell(30,6,'Item Requested',1,0,'L',true);
		$pdf->Cell(30,6,'Item Shipped',1,0,'L',true);
		$pdf->Cell(50,6,'Description',1,0,'L',true);
		$pdf->Cell(30,6,'Unit Price',1,0,'R',true);
		$pdf->Cell(30,6,'Total',1,1,'R',true);

		// set the text color to black
		$pdf->SetTextColor(0,0,0);

		$pdf->SetFont('Arial','',10);
		$pdf->Cell(20,6,number_format($inv['Quantity'], 0, '.', ''),0,0,'L');
		$pdf->Cell(30,6,$inv['U_ReqItem'],0,0,'L');
		$pdf->Cell(30,6,$inv['ItemCode'],0,0,'L');
		$pdf->Cell(50,6,$inv['Dscription'],0,0,'L');
		$pdf->Cell(30,6,number_format($inv['Price'], 2, '.', ''),0,0,'R');
		$pdf->Cell(30,6,number_format($inv['LineTotal'], 2, '.', ''),0,1,'R');
		
		// get the current y position
		$y=$pdf->GetY();

		$pdf->Line(10, $y, 200, $y);
		$pdf->Ln(5);
		$pdf->Cell(130,6,'',0,0,'L');
		$pdf->Cell(30,6,'Subtotal',0,0,'R');
		$pdf->Cell(30,6,number_format($inv['DocTotal'], 2, '.', ''),0,1,'R');
		$pdf->Cell(130,6,'',0,0,'L');
		$pdf->Cell(30,6,'Sales Tax',0,0,'R');
		$pdf->Cell(30,6,number_format($inv['VatSum'], 2, '.', ''),0,1,'R');
		$pdf->Cell(130,6,'',0,0,'L');
		$pdf->Cell(30,6,'Freight',0,0,'R');
		$pdf->Cell(30,6,number_format($inv['TotalExpns'], 2, '.', ''),0,1,'R');
		$pdf->Cell(140,6,'',0,0,'L');
		$pdf->Cell(20,1,'','B',0,'R');
		$pdf->Cell(30,1,'','B',1,'R');
		$pdf->Cell(130,6,'',0,0,'L');
		$pdf->Cell(30,6,'Total',0,0,'R');
		$pdf->Cell(30,6,number_format($inv['DocTotal'], 2, '.', ''),0,1,'R');
		$pdf->Cell(140,6,'',0,0,'L');
		$pdf->Cell(20,1,'','TB',0,'R');
		$pdf->Cell(30,1,'','TB',1,'R');
		$pdf->Ln(5);
		$pdf->SetFont('Arial','I',9);
		$pdf->Cell(140,3,'',0,0,'L');
		$pdf->Cell(50,3,'Please remit payyment to:',0,1,'L');
		$pdf->Cell(140,3,'',0,0,'L');
		$pdf->Cell(50,3,'Techni-Car, Inc.',0,1,'L');
		$pdf->Cell(140,3,'',0,0,'L');
		$pdf->Cell(50,3,'450 Commerce Blvd.',0,1,'L');
		$pdf->Cell(140,3,'',0,0,'L');
		$pdf->Cell(50,3,'Oldsmar, FL 34677',0,1,'L');
		
		$pdf->ftr = "Warranty Information:  All instrumentation cluster, audio, and infotainment products internally exchanged or refurbished by Techni-Car carry a 12 month / 12,000 mile Limited Warranty from the original date of purchase to the original purchaser. All warranties are limited to the repair or replacement of the purchased product and do not cover diagnostic time, technical labor, car rental, vehicle damage, or any other incidental costs. All OEM sales and aftermarket products purchased from Techni-Car carry the manufacturer's stated warranty.";
		
//for($i=1;$i<=3;$i++)
//    $zpdf->Cell(0,10,'Printing line number '.$i,0,1);
$pdf->Output();
?>	
