<?PHP
if (!session_id())
	session_start();
include_once("inc/inc.php");
//require('inc/fpdf.php');
require('inc/code39.php');

class PDF extends PDF_Code39
{
	var $order;
// Page header
function Header()
{
    // Logo
    $this->Image('images/technicar.png',10,6,80,20);
    // Arial bold 15
    $this->SetFont('Arial','B',15);
    // Move to the right
    $this->Cell(130);
	// Set text color to white
	$this->SetTextColor(255,255,255);
	// Set the fill color
	$this->SetFillColor(0,0,0);
    // Title
	$won = $_GET['son'];
    $this->Cell(60,10,'Sales Order',1,1,'C',true);
    // Line break
    $this->Ln(7);
	// Set text color to black
	$this->SetTextColor(0,0,0);
    // Set font to Arial bold 6
    $this->SetFont('Arial','',10);

	$this->Cell(40,5,'450 Commerce Blvd.',0,0,'L');
	$this->Cell(40,5,'PH: (800) 886-0022',0,0,'R');
	$this->Cell(50);
    $this->SetFont('Arial','B',18);
	$this->Cell(60,5,$won,0,1,'C');

    $this->SetFont('Arial','',10);
	$this->Cell(40,5,'Oldsmar, FL 34677',0,0,'L');
	$this->Cell(40,5,'FAX: (813) 855-2101',0,1,'R');
	
	$this->Cell(40,5,'www.techni-car.com',0,0,'L');
	$this->Cell(40,5,'csr@techni-car.com',0,0,'R');
    $this->SetFont('Arial','B',12);
	$this->Cell(110,5,'** This is not an invoice **',0,1,'R');

	// Line Break
	$this->Ln(10);
}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Page number
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
}
}

$User = get_user_info();
$won = $_GET['won'];
$son = $_GET['son'];

$order = get_order($_GET['son'], $_GET['won'], $User['DealerCode']);
// massage the data as in the html view
if (empty($order['UpdateDate']))
	$order['UpdateDate'] = $order['CreateDate'];

$query ="Select ";

$warrantylist = array('Warranty' => 'Warranty', 'OutOfWarranty' => 'Out Of Warranty', 'ESPWarranty' => 'ESP Warranty', 'Recheck' => 'Recheck', 'Campaign' => 'Campaign', 'CUV' => 'Certified Used Vehicle');
foreach ($warrantylist as $key => $val) {
	if ($order[$key] == "1") {
		$WntyStatus = $key;
		$WntyDisplayStatus = $val;
	}
}

if ($WntyStatus == 'OutOfWarranty')
{
	if (!empty($order['price'])) {
		if ($order['price'] != '0') 
			$price = number_format($order['price'], 2, '.', '');
		else
			$price = 'CALL';
	}
	else
		$price = 'CALL';
}

if ($User['IsKiaDealer'] != '1')
{
	if ($order['GoodWill'] == '1')
	{
		$REPAIR_STATUS .= '<tr><td><input type="checkbox" name="Goodwill" value="1" checked disabled>Goodwill - Authorization</td><td>';
		
		if (!empty($order['GWAuth']))
			$REPAIR_STATUS .=  $order['GWAuth'];
			
		$REPAIR_STATUS .=  '</td></tr>';
	}
	else
		$REPAIR_STATUS .= '<tr><td><input type="checkbox" name="Goodwill" value="1" disabled> Goodwill - Authorization</td><td></td></tr>';
}	

unset($STATUSARRAY['%']);

$status_select = create_assoc_select($STATUSARRAY, $order['Status']);

$tracking = $order['OBTrackNum'];

if (!empty($tracking))
{
	switch ($order['ShipVia'])
	{
		case 2:
			$tracking = "<a href=http://wwwapps.ups.com/WebTracking/processRequest?&tracknum=".$order['OBTrackNum']." target=_blank>".$order['OBTrackNum']."</a>";
		break;
		case 3:
			$tracking = "<a href=http://wwwapps.ups.com/WebTracking/processRequest?&tracknum=".$order['OBTrackNum']." target=_blank>".$order['OBTrackNum']."</a>";
		break;
		case 4:
			$tracking = "<a href='http://fedex.com/Tracking?action=track&tracknumber_list=".$order['OBTrackNum']."&cntry_code=us' target=_blank>".$order['OBTrackNum']."</a>";
		break;
		case 6:
			$tracking = "<a href='http://fedex.com/Tracking?action=track&tracknumber_list=".$order['OBTrackNum']."&cntry_code=us' target=_blank>".$order['OBTrackNum']."</a>";
		break;
		case 7:
			$tracking = "<a href='http://fedex.com/Tracking?action=track&tracknumber_list=".$order['OBTrackNum']."&cntry_code=us' target=_blank>".$order['OBTrackNum']."</a>";
		break;
		case 10:
			$tracking = "<a href='http://fedex.com/Tracking?action=track&tracknumber_list=".$order['OBTrackNum']."&cntry_code=us' target=_blank>".$order['OBTrackNum']."</a>";
		break;
		case 13:
			$tracking = "<a href='http://fedex.com/Tracking?action=track&tracknumber_list=".$order['OBTrackNum']."&cntry_code=us' target=_blank>".$order['OBTrackNum']."</a>";
		break;
	}
}

if ($order['ProgReq'] == '1')
	$ProgReq = "Yes";
else 
 	$ProgReq = "No";

if ($order['KiaReplaceShroud'] == '1')
	$ReplaceShroud = "Yes";
else
	$ReplaceShroud = "No";

if ($order['EngHrsReq'] == '1')
	$EngHrsReq = "Yes";
else
	$EngHrsReq = "No";

if ($order['OdoType'] == 'K')
	$OdoType = "Kilometers";
else
	$OdoType = "Miles";
	
$pqc = "";

if ($order['PQCReq'] == 'Y' && (empty($order['PQCAuth'])))
	$pqc = '<p><font color="red">A GM Instrument Cluster PQC Questionnaire must be completed with the order and has not been done. This order may be held up until the questionnaire is completed. Click <a href="pqcc.php?son= &won='.$won.'">here</a> to complete the questiionnaire now.</font></p>';
// end of data massage.


// Create the pdf
$pdf = new PDF();
//$pdf = new PDF_Code39();
// get the order detail from SAP
$pdf->AliasNbPages();
$pdf->AddPage('P','Letter');
$pdf->SetFont('Arial','B',10);
$pdf->Cell(190,6,'General Information:',1,1,'L');

$pdf->Cell(60,6,'Part Ordered','LT',0,'L');
$pdf->Cell(65,6,'Part In Vehicle','LT',0,'L');
$pdf->Cell(65,6,'Dealer Contact','LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(60,6,$order['PartNum'],'LB',0,'L');
$pdf->Cell(65,6,$order['PartNumInVehicle'],'LB',0,'L');
$pdf->Cell(65,6,$order['DealerContactName'],'LBR',1,'L');

$pdf->SetFont('Arial','B',10);
$pdf->Cell(60,6,'Purchase Order #','LT',0,'L');
$pdf->Cell(65,6,'Date Ordered','LT',0,'L');
$pdf->Cell(65,6,'Status','LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(60,6,$order['PONum'],'LB',0,'L');
$pdf->Cell(65,6,$order['CreateDate'],'LB',0,'L');
$pdf->Cell(65,6,$STATUSARRAY[$order['Status']],'LBR',1,'L');

$pdf->SetFont('Arial','B',10);
$pdf->Cell(60,6,'Shipped Via','LT',0,'L');
$pdf->Cell(65,6,'Tracking #','LT',0,'L');
$pdf->Cell(65,6,'Web Order #','LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(60,6,$SHIPMETHODS_ARRAY[$order['ShipVia']],'LB',0,'L');
$pdf->Cell(65,6,$order['OBTrackNum'],'LB',0,'L');
$pdf->Cell(65,6,$order['WebOrderNum'],'LBR',1,'L');

$pdf->Ln(3);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(190,6,'Vehicle Information:',1,1,'L');

$pdf->Cell(60,6,'VIN','LT',0,'L');
$pdf->Cell(45,6,'Odometer Reading','LT',0,'L');
$pdf->Cell(20,6,'Odo Type','LT',0,'L');
$pdf->Cell(65,6,'Delivery Date','LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(60,6,$order['VIN'],'LB',0,'L');
$pdf->Cell(45,6,$order['Odometer'],'LB',0,'L');
$pdf->Cell(20,6,'Miles','LB',0,'L');
$pdf->Cell(65,6,$order['DeliveryDate'],'LBR',1,'L');

$pdf->SetFont('Arial','B',10);
$pdf->Cell(60,6,'Repair Order #','LT',0,'L');
$pdf->Cell(65,6,'RO Date','LT',0,'L');
if ($User['IsKiaDealer'] == '1')
	$pdf->Cell(65,6,'Replace Shroud?','LBR',1,'L');
else
	$pdf->Cell(65,6,'Axle Ratio','LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(60,6,$order['RONumber'],'LB',0,'L');
$pdf->Cell(65,6,$order['RODate'],'LB',0,'L');
if ($User['IsKiaDealer'] == '1')
	$pdf->Cell(65,6,$ReplaceShroud,'LBR',1,'L');
else
	$pdf->Cell(65,6,$order['AxleRatio'],'LBR',1,'L');

$pdf->SetFont('Arial','B',10);
$pdf->Cell(40,6,'TCI to program?','LT',0,'L');
$pdf->Cell(70,6,'Vehicle Requires SEO Programming?','LT',0,'L');
$pdf->Cell(40,6,'Service Engine Hours','LT',0,'L');
$pdf->Cell(40,6,'Tire Size','LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(40,6,$ProgReq,'LB',0,'L');
$pdf->Cell(70,6,$EngHrsReq,'LB',0,'L');
$pdf->Cell(40,6,$order['ServiceEngineHrs'],'LB',0,'L');
$pdf->Cell(40,6,$order['TireSize'],'LBR',1,'L');

$pdf->Ln(3);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(190,6,'Customer Information:',1,1,'L');

$pdf->SetFont('Arial','',10);
$pdf->Cell(190,6,$order['CustomerName'],'LTR',1,'L');
$pdf->Cell(190,18,replace_ascii_control_chars($order['Address']),'LRB',1,'L');

$pdf->Ln(3);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(190,6,'Warranty Information:',1,1,'L');

$pdf->Cell(60,6,'Warranty Status:','LT',0,'L');
if ($WntyStatus == 'OutOfWarranty')
	$pdf->Cell(65,6,'Price','LT',0,'L');
else
	$pdf->Cell(65,6,'','LT',0,'L');
if ($order['Recheck'] == '1')
	$pdf->Cell(65,6,'Recheck -- Previous RO Number','LTR',1,'L');
else
	$pdf->Cell(65,6,'','LTR',1,'L');

$pdf->SetFont('Arial','',10);
$pdf->Cell(60,6,$WntyDisplayStatus,'LB',0,'L');
if ($WntyStatus == 'OutOfWarranty')
	$pdf->Cell(65,6,$price,'LB',0,'L');
else
	$pdf->Cell(65,6,'','LB',0,'L');
if ($order['Recheck'] == '1')
{
	if (!empty($order['PreviousRONumber']))
		$pdf->Cell(65,6,$order['PreviousRONumber'],'LBR',1,'L');
	else
		$pdf->Cell(65,6,'','LBR',1,'L');
}
else
	$pdf->Cell(65,6,'','LBR',1,'L');

$pdf->SetFont('Arial','B',10);
$pdf->Cell(190,6,Complaint,'LTR',1,'L');
$pdf->SetFont('Arial','',10);
$pdf->Cell(190,10,stripslashes_mssql($order['Complaint']),'LRB',1,'L');

$pdf->Ln(3);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(190,6,'Additional Information:',1,1,'L');

$pdf->SetFont('Arial','',10);
$pdf->Cell(190,10,$order['AdditionalComments'],'LRB',1,'L');


$pdf->Code39(80,250,'CODE 39',1,10);

//$pdf->Code39(40,-15,'code39',1,10);

//for($i=1;$i<=3;$i++)
//    $pdf->Cell(0,10,'Printing line number '.$i,0,1);
$pdf->Output();
?>	
