<?PHP
//require('inc/fpdf.php');
require('inc/code39.php');

class PDF extends FPDF
{
// Page header
function Header()
{
    // Logo
    $this->Image('images/technicar.png',10,6,0);
    // Arial bold 15
    $this->SetFont('Arial','B',15);
    // Move to the right
    $this->Cell(160);
	// Set text color to white
	$this->SetTextColor(255,255,255);
	// Set the fill color
	$this->SetFillColor(0,0,0);
    // Title
    $this->Cell(30,10,'INVOICE',1,1,'C',true);
    // Line break
    $this->Ln(2);
	// Set text color to black
	$this->SetTextColor(0,0,0);
    // Set font to Arial bold 6
    $this->SetFont('Arial','',6);

	$this->Cell(30,5,'450 Commerce Blvd.',0,0,'L');
	$this->Cell(30,5,'Phone: (800) 886-0022',0,0,'L');
	$this->Cell(30,5,'Invoice #:',0,0,'R');
	$this->Cell(30,5,'526998',0,1,'R');


	// Line Break
	$this->Ln(20);
}

// Page footer
function Footer()
{
    // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','I',8);
    // Page number
    $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
}
}

// Instanciation of inherited class
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial','B',10);
$pdf->Cell(130,6,'Bill To',1,0,'L');
$pdf->Cell(60,6,'Ship To',1,1,'L');

for($i=1;$i<=40;$i++)
    $pdf->Cell(0,10,'Printing line number '.$i,0,1);
$pdf->Output();
?>	
